/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.SpecializedEventContext;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.entity.NetworkVoltronEntityMessage;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityResponse;
import com.tc.logging.ClientIDLogger;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnknownNameException;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientEntityStateManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityClientEndpointImpl;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.InFlightMessage;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.stats.Stats;
import com.tc.text.PrettyPrinter;
import com.tc.util.Assert;
import com.tc.util.Throwables;
import com.tc.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.terracotta.connection.ConnectionException;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;

public class ClientEntityManagerImpl
implements ClientEntityManager {
    private final TCLogger logger;
    private final ClientMessageChannel channel;
    private final ConcurrentMap<TransactionID, InFlightMessage> inFlightMessages;
    private final Sink<InFlightMessage> outbound;
    private final Semaphore requestTickets;
    private final AtomicLong currentTransactionID;
    private final ClientEntityStateManager stateManager;
    private final ConcurrentMap<EntityDescriptor, EntityClientEndpoint<?, ?>> objectStoreMap;
    private final StageManager stages;
    private boolean isShutdown = false;

    public ClientEntityManagerImpl(ClientMessageChannel channel, StageManager mgr) {
        this.logger = new ClientIDLogger(channel, TCLogging.getLogger(ClientEntityManager.class));
        this.channel = channel;
        this.inFlightMessages = new ConcurrentHashMap<TransactionID, InFlightMessage>();
        this.requestTickets = new Semaphore(ClientConfigurationContext.MAX_SENT_REQUESTS);
        this.currentTransactionID = new AtomicLong();
        this.stateManager = new ClientEntityStateManager();
        this.objectStoreMap = new ConcurrentHashMap(10240, 0.75f, 128);
        this.stages = mgr;
        this.outbound = this.createSendStage(this.stages);
    }

    private Sink<InFlightMessage> createSendStage(StageManager stages) {
        AbstractEventHandler<InFlightMessage> handler = new AbstractEventHandler<InFlightMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleEvent(InFlightMessage first) throws EventHandlerException {
                try {
                    ClientEntityManagerImpl.this.requestTickets.acquire();
                    boolean doSend = false;
                    ClientEntityManagerImpl clientEntityManagerImpl = ClientEntityManagerImpl.this;
                    synchronized (clientEntityManagerImpl) {
                        if (!ClientEntityManagerImpl.this.isShutdown) {
                            ClientEntityManagerImpl.this.inFlightMessages.put(first.getTransactionID(), first);
                            first.sent();
                            doSend = true;
                        }
                    }
                    if (doSend) {
                        if (first.send()) {
                            if (first.getMessage().getVoltronType() != VoltronEntityMessage.Type.INVOKE_ACTION) {
                                first.waitForAcks();
                            }
                        } else {
                            ClientEntityManagerImpl.this.logger.warn("message not sent.  Make sure resend happens " + first);
                        }
                    } else {
                        ClientEntityManagerImpl.this.requestTickets.release();
                        ClientEntityManagerImpl.this.throwClosedExceptionOnMessage(first);
                    }
                }
                catch (InterruptedException ie) {
                    throw new EventHandlerException(ie);
                }
            }
        };
        return this.makeDirectSink(handler);
    }

    private <T> Sink<T> makeDirectSink(final EventHandler<T> handler) {
        return new Sink<T>(){

            @Override
            public void addSingleThreaded(T context) {
                try {
                    handler.handleEvent(context);
                }
                catch (EventHandlerException ee) {
                    throw new RuntimeException(ee);
                }
            }

            @Override
            public void addMultiThreaded(T context) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void addSpecialized(SpecializedEventContext specialized) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public void clear() {
            }

            @Override
            public void setClosed(boolean closed) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void enableStatsCollection(boolean enable) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean isStatsCollectionEnabled() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Stats getStats(long frequency) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Stats getStatsAndReset(long frequency) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void resetStats() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public EntityClientEndpoint fetchEntity(EntityDescriptor entityDescriptor, MessageCodec<? extends EntityMessage, ? extends EntityResponse> codec, Runnable closeHook) throws EntityException {
        return this.internalLookup(entityDescriptor, codec, closeHook);
    }

    @Override
    public void handleMessage(EntityDescriptor entityDescriptor, byte[] message) {
        EntityClientEndpoint endpoint = (EntityClientEndpoint)this.objectStoreMap.get(entityDescriptor);
        if (endpoint != null) {
            EntityClientEndpointImpl endpointImpl = (EntityClientEndpointImpl)endpoint;
            try {
                endpointImpl.handleMessage(message);
            }
            catch (MessageCodecException e) {
                Assert.fail(e.getLocalizedMessage());
            }
        } else {
            this.logger.info("Entity " + entityDescriptor + " not found. Ignoring message.");
        }
    }

    @Override
    public InvokeFuture<byte[]> createEntity(EntityID entityID, long version, byte[] config) {
        boolean requiresReplication = true;
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, config, VoltronEntityMessage.Type.CREATE_ENTITY);
        boolean shouldBlockGetOnRetire = false;
        return this.createInFlightMessageAfterAcks(message, this.lifecycleAcks(), shouldBlockGetOnRetire);
    }

    @Override
    public InvokeFuture<byte[]> reconfigureEntity(EntityID entityID, long version, byte[] config) {
        boolean requiresReplication = true;
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, config, VoltronEntityMessage.Type.RECONFIGURE_ENTITY);
        boolean shouldBlockGetOnRetire = false;
        return this.createInFlightMessageAfterAcks(message, this.lifecycleAcks(), shouldBlockGetOnRetire);
    }

    private Set<VoltronEntityMessage.Acks> lifecycleAcks() {
        return Collections.singleton(VoltronEntityMessage.Acks.RETIRED);
    }

    @Override
    public InvokeFuture<byte[]> destroyEntity(EntityID entityID, long version) {
        boolean requiresReplication = true;
        byte[] emtpyExtendedData = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, emtpyExtendedData, VoltronEntityMessage.Type.DESTROY_ENTITY);
        boolean shouldBlockGetOnRetire = false;
        return this.createInFlightMessageAfterAcks(message, this.lifecycleAcks(), shouldBlockGetOnRetire);
    }

    @Override
    public InvokeFuture<byte[]> invokeAction(EntityDescriptor entityDescriptor, Set<VoltronEntityMessage.Acks> requestedAcks, boolean requiresReplication, boolean shouldBlockGetOnRetire, byte[] payload) {
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.INVOKE_ACTION);
        return this.createInFlightMessageAfterAcks(message, requestedAcks, shouldBlockGetOnRetire);
    }

    @Override
    public synchronized PrettyPrinter prettyPrint(PrettyPrinter out) {
        out.print(this.getClass().getName()).flush();
        out.duplicateAndIndent().indent().print(this.stateManager.getCurrentState()).flush();
        out.duplicateAndIndent().indent().print("inFlightMessages size: ").print(this.inFlightMessages.size()).flush();
        out.duplicateAndIndent().indent().print("outbound size: ").print(this.outbound.size()).flush();
        out.duplicateAndIndent().indent().print("objectStoreMap size: ").print(this.objectStoreMap.size()).flush();
        return out;
    }

    @Override
    public void received(TransactionID id) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.received();
        }
    }

    @Override
    public void complete(TransactionID id) {
        this.complete(id, null);
    }

    @Override
    public void complete(TransactionID id, byte[] value) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.setResult(value, null);
        }
    }

    @Override
    public void failed(TransactionID id, EntityException error) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.setResult(null, error);
        }
    }

    @Override
    public void retired(TransactionID id) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.remove(id);
        if (inFlight != null) {
            inFlight.retired();
        }
        this.requestTickets.release();
    }

    @Override
    public synchronized void pause() {
        this.stateManager.pause();
    }

    @Override
    public synchronized void unpause() {
        this.stateManager.running();
    }

    @Override
    public synchronized void initializeHandshake(ClientHandshakeMessage handshakeMessage) {
        this.stateManager.start();
        for (EntityDescriptor descriptor : this.objectStoreMap.keySet()) {
            EntityID entityID = descriptor.getEntityID();
            long entityVersion = descriptor.getClientSideVersion();
            ClientInstanceID clientInstanceID = descriptor.getClientInstanceID();
            byte[] extendedReconnectData = ((EntityClientEndpoint)this.objectStoreMap.get(descriptor)).getExtendedReconnectData();
            ClientEntityReferenceContext context = new ClientEntityReferenceContext(entityID, entityVersion, clientInstanceID, extendedReconnectData);
            handshakeMessage.addReconnectReference(context);
        }
        Stage<VoltronEntityResponse> responder = this.stages.getStage("request_ack_stage", VoltronEntityResponse.class);
        Stage<VoltronEntityMultiResponse> responderMulti = this.stages.getStage("multi_request_ack_stage", VoltronEntityMultiResponse.class);
        FlushResponse flush = new FlushResponse();
        responder.getSink().addSingleThreaded(flush);
        flush.waitForAccess();
        flush = new FlushResponse();
        responderMulti.getSink().addSingleThreaded(flush);
        flush.waitForAccess();
        for (InFlightMessage inFlight : this.inFlightMessages.values()) {
            NetworkVoltronEntityMessage message = inFlight.getMessage();
            ResendVoltronEntityMessage packaged = new ResendVoltronEntityMessage(message.getSource(), message.getTransactionID(), message.getEntityDescriptor(), message.getVoltronType(), message.doesRequireReplication(), message.getExtendedData(), message.getOldestTransactionOnClient());
            handshakeMessage.addResendMessage(packaged);
        }
    }

    @Override
    public synchronized void shutdown(boolean fromShutdownHook) {
        this.isShutdown = true;
        this.stateManager.stop();
        for (InFlightMessage msg : this.inFlightMessages.values()) {
            this.throwClosedExceptionOnMessage(msg);
        }
        for (EntityClientEndpoint endpoint : this.objectStoreMap.values()) {
            try {
                endpoint.didCloseUnexpectedly();
            }
            catch (Throwable t) {
                this.logger.error("error in shutdown", t);
            }
        }
        this.objectStoreMap.clear();
        this.notifyAll();
    }

    private void throwClosedExceptionOnMessage(InFlightMessage msg) {
        msg.received();
        msg.setResult(null, new EntityException(msg.getMessage().getEntityDescriptor().getEntityID().getClassName(), msg.getMessage().getEntityDescriptor().getEntityID().getEntityName(), "connection closed", new ConnectionException(null)){});
        msg.retired();
    }

    private <M extends EntityMessage, R extends EntityResponse> EntityClientEndpoint<M, R> internalLookup(final EntityDescriptor entityDescriptor, MessageCodec<M, R> codec, final Runnable closeHook) throws EntityException {
        Assert.assertNotNull("Can't lookup null entity descriptor", entityDescriptor);
        EntityClientEndpointImpl<M, R> resolvedEndpoint = null;
        try {
            byte[] config = this.internalRetrieve(entityDescriptor);
            Assert.assertTrue(null != config);
            Runnable compoundRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientEntityManagerImpl.this.internalRelease(entityDescriptor, closeHook);
                    }
                    catch (EntityException e) {
                        Util.printLogAndRethrowError(e, ClientEntityManagerImpl.this.logger);
                    }
                }
            };
            resolvedEndpoint = new EntityClientEndpointImpl<M, R>(entityDescriptor, this, config, codec, compoundRunnable);
            if (null != this.objectStoreMap.get(entityDescriptor)) {
                throw Assert.failure("Attempt to add an object that already exists: Object of class " + resolvedEndpoint.getClass() + " [Identity Hashcode : 0x" + Integer.toHexString(System.identityHashCode(resolvedEndpoint)) + "] ");
            }
            this.objectStoreMap.put(entityDescriptor, resolvedEndpoint);
        }
        catch (EntityNotFoundException notfound) {
            throw notfound;
        }
        catch (EntityException e) {
            this.internalRelease(entityDescriptor, null);
            throw e;
        }
        catch (Throwable t) {
            this.logger.warn("Exception retrieving entity descriptor " + entityDescriptor, t);
            this.internalRelease(entityDescriptor, null);
            throw Throwables.propagate(t);
        }
        return resolvedEndpoint;
    }

    private void internalRelease(EntityDescriptor entityDescriptor, Runnable closeHook) throws EntityException {
        this.stateManager.waitUntilRunning();
        EnumSet<VoltronEntityMessage.Acks> requestedAcks = EnumSet.of(VoltronEntityMessage.Acks.APPLIED);
        boolean requiresReplication = true;
        byte[] payload = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.RELEASE_ENTITY);
        this.synchronousWaitForResponse(message, requestedAcks);
        this.objectStoreMap.remove(entityDescriptor);
        if (closeHook != null) {
            closeHook.run();
        }
    }

    private byte[] synchronousWaitForResponse(NetworkVoltronEntityMessage message, Set<VoltronEntityMessage.Acks> requestedAcks) throws EntityException {
        boolean shouldBlockGetOnRetire = false;
        InFlightMessage inFlight = this.createInFlightMessageAfterAcks(message, requestedAcks, shouldBlockGetOnRetire);
        byte[] result = null;
        try {
            result = inFlight.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private byte[] internalRetrieve(EntityDescriptor entityDescriptor) throws EntityException {
        this.stateManager.waitUntilRunning();
        EnumSet<VoltronEntityMessage.Acks> requestedAcks = EnumSet.of(VoltronEntityMessage.Acks.APPLIED);
        boolean requiresReplication = true;
        byte[] payload = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.FETCH_ENTITY);
        return this.synchronousWaitForResponse(message, requestedAcks);
    }

    private InFlightMessage createInFlightMessageAfterAcks(NetworkVoltronEntityMessage message, Set<VoltronEntityMessage.Acks> requestedAcks, boolean shouldBlockGetOnRetire) {
        InFlightMessage inFlight = new InFlightMessage(message, requestedAcks, shouldBlockGetOnRetire);
        this.outbound.addSingleThreaded(inFlight);
        inFlight.waitForAcks();
        return inFlight;
    }

    private NetworkVoltronEntityMessage createMessageWithoutClientInstance(EntityID entityID, long version, boolean requiresReplication, byte[] config, VoltronEntityMessage.Type type) {
        EntityDescriptor entityDescriptor = new EntityDescriptor(entityID, ClientInstanceID.NULL_ID, version);
        return this.createMessageWithDescriptor(entityDescriptor, requiresReplication, config, type);
    }

    private NetworkVoltronEntityMessage createMessageWithDescriptor(EntityDescriptor entityDescriptor, boolean requiresReplication, byte[] config, VoltronEntityMessage.Type type) {
        TransactionID transactionID;
        ClientID clientID = this.channel.getClientID();
        TransactionID oldestTransactionPending = transactionID = new TransactionID(this.currentTransactionID.incrementAndGet());
        for (TransactionID pendingID : this.inFlightMessages.keySet()) {
            if (oldestTransactionPending.compareTo(pendingID) <= 0) continue;
            oldestTransactionPending = pendingID;
        }
        NetworkVoltronEntityMessage message = (NetworkVoltronEntityMessage)this.channel.createMessage(TCMessageType.VOLTRON_ENTITY_MESSAGE);
        message.setContents(clientID, transactionID, entityDescriptor, type, requiresReplication, config, oldestTransactionPending);
        return message;
    }

    private static class FlushResponse
    implements VoltronEntityResponse,
    VoltronEntityMultiResponse {
        private boolean accessed = false;

        private FlushResponse() {
        }

        @Override
        public synchronized TransactionID getTransactionID() {
            this.notifyAll();
            this.accessed = true;
            return TransactionID.NULL_ID;
        }

        @Override
        public VoltronEntityMessage.Acks getAckType() {
            return VoltronEntityMessage.Acks.RECEIVED;
        }

        @Override
        public TCMessageType getMessageType() {
            return TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE;
        }

        @Override
        public void hydrate() throws IOException, UnknownNameException {
        }

        @Override
        public void dehydrate() {
        }

        @Override
        public boolean send() {
            return true;
        }

        @Override
        public MessageChannel getChannel() {
            return null;
        }

        @Override
        public NodeID getSourceNodeID() {
            return ServerID.NULL_ID;
        }

        @Override
        public NodeID getDestinationNodeID() {
            return ClientID.NULL_ID;
        }

        @Override
        public SessionID getLocalSessionID() {
            return SessionID.NULL_ID;
        }

        @Override
        public int getTotalLength() {
            return 0;
        }

        @Override
        public synchronized TransactionID[] getReceivedTransactions() {
            this.accessed = true;
            this.notifyAll();
            return new TransactionID[0];
        }

        @Override
        public TransactionID[] getRetiredTransactions() {
            return new TransactionID[0];
        }

        @Override
        public Map<TransactionID, byte[]> getResults() {
            return Collections.emptyMap();
        }

        @Override
        public boolean addReceived(TransactionID tid) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addRetired(TransactionID tid) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addResult(TransactionID tid, byte[] result) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public synchronized void waitForAccess() {
            boolean interrupted = false;
            while (!this.accessed) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

