/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.client.internal.store.operations.LazyValueHolder;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.OperationCode;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.CodecException;
import org.ehcache.spi.serialization.Serializer;

public class ConditionalReplaceOperation<K, V>
implements Operation<K, V>,
Result<V> {
    private final K key;
    private final LazyValueHolder<V> oldValueHolder;
    private final LazyValueHolder<V> newValueHolder;
    private final long timeStamp;

    public ConditionalReplaceOperation(K key, V oldValue, V newValue, long timeStamp) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        this.key = key;
        if (oldValue == null) {
            throw new NullPointerException("Old value can not be null");
        }
        this.oldValueHolder = new LazyValueHolder<V>(oldValue);
        if (newValue == null) {
            throw new NullPointerException("New value can not be null");
        }
        this.newValueHolder = new LazyValueHolder<V>(newValue);
        this.timeStamp = timeStamp;
    }

    ConditionalReplaceOperation(ByteBuffer buffer, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        OperationCode opCode = OperationCode.valueOf(buffer.get());
        if (opCode != this.getOpCode()) {
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)opCode));
        }
        this.timeStamp = buffer.getLong();
        int keySize = buffer.getInt();
        int maxLimit = buffer.limit();
        buffer.limit(buffer.position() + keySize);
        ByteBuffer keyBlob = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(maxLimit);
        int oldValueSize = buffer.getInt();
        buffer.limit(buffer.position() + oldValueSize);
        ByteBuffer oldValueBlob = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(maxLimit);
        ByteBuffer valueBlob = buffer.slice();
        try {
            this.key = keySerializer.read(keyBlob);
        }
        catch (ClassNotFoundException e) {
            throw new CodecException(e);
        }
        this.oldValueHolder = new LazyValueHolder<V>(oldValueBlob, valueSerializer);
        this.newValueHolder = new LazyValueHolder<V>(valueBlob, valueSerializer);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    V getOldValue() {
        return this.oldValueHolder.getValue();
    }

    @Override
    public V getValue() {
        return this.newValueHolder.getValue();
    }

    @Override
    public OperationCode getOpCode() {
        return OperationCode.REPLACE_CONDITIONAL;
    }

    @Override
    public Result<V> apply(Result<V> previousResult) {
        if (previousResult == null) {
            return null;
        }
        if (this.getOldValue().equals(previousResult.getValue())) {
            return this;
        }
        return previousResult;
    }

    @Override
    public ByteBuffer encode(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ByteBuffer keyBuf = keySerializer.serialize(this.key);
        ByteBuffer oldValueBuf = this.oldValueHolder.encode(valueSerializer);
        ByteBuffer valueBuf = this.newValueHolder.encode(valueSerializer);
        ByteBuffer buffer = ByteBuffer.allocate(13 + keyBuf.remaining() + 4 + oldValueBuf.remaining() + valueBuf.remaining());
        buffer.put(this.getOpCode().getValue());
        buffer.putLong(this.timeStamp);
        buffer.putInt(keyBuf.remaining());
        buffer.put(keyBuf);
        buffer.putInt(oldValueBuf.remaining());
        buffer.put(oldValueBuf);
        buffer.put(valueBuf);
        buffer.flip();
        return buffer;
    }

    public String toString() {
        return "{" + (Object)((Object)this.getOpCode()) + "# key: " + this.key + ", oldValue: " + this.getOldValue() + ", newValue: " + this.getValue() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalReplaceOperation)) {
            return false;
        }
        ConditionalReplaceOperation other = (ConditionalReplaceOperation)obj;
        if (this.getOpCode() != other.getOpCode()) {
            return false;
        }
        if (!this.getKey().equals(other.getKey())) {
            return false;
        }
        if (!this.getValue().equals(other.getValue())) {
            return false;
        }
        return this.getOldValue().equals(other.getOldValue());
    }

    public int hashCode() {
        int hash = this.getOpCode().hashCode();
        hash = hash * 31 + this.key.hashCode();
        hash = hash * 31 + this.getOldValue().hashCode();
        hash = hash * 31 + this.getValue().hashCode();
        return hash;
    }

    @Override
    public long timeStamp() {
        if (!this.isExpiryAvailable()) {
            return this.timeStamp;
        }
        throw new RuntimeException("Timestamp not available");
    }

    @Override
    public boolean isExpiryAvailable() {
        return this.timeStamp < 0L;
    }

    @Override
    public long expirationTime() {
        if (this.isExpiryAvailable()) {
            return -this.timeStamp;
        }
        throw new RuntimeException("Expiry not available");
    }
}

