/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import com.tc.util.UUID;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class ClientHandshakeMessageImpl
extends DSOMessageBase
implements ClientHandshakeMessage {
    private static final byte LOCK_CONTEXT = 1;
    private static final byte CLIENT_VERSION = 2;
    private static final byte ENTERPRISE_CLIENT = 3;
    private static final byte LOCAL_TIME_MILLS = 4;
    private static final byte RECONNECT_REFERENCES = 5;
    private static final byte RESEND_MESSAGES = 6;
    private static final byte CLIENT_PID = 7;
    private static final byte CLIENT_UUID = 8;
    private static final byte CLIENT_NAME = 9;
    private final Set<ClientServerExchangeLockContext> lockContexts = new HashSet<ClientServerExchangeLockContext>();
    private long currentLocalTimeMills = System.currentTimeMillis();
    private boolean enterpriseClient = false;
    private String uuid = UUID.NULL_ID.toString();
    private String name = "";
    private String clientVersion = "UNKNOWN";
    private int pid = -1;
    private final Set<ClientEntityReferenceContext> reconnectReferences = new HashSet<ClientEntityReferenceContext>();
    private final Set<ResendVoltronEntityMessage> resendMessages = new TreeSet<ResendVoltronEntityMessage>(new Comparator<ResendVoltronEntityMessage>(){

        @Override
        public int compare(ResendVoltronEntityMessage first, ResendVoltronEntityMessage second) {
            return first.getTransactionID().compareTo(second.getTransactionID());
        }
    });

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
    }

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public Collection<ClientServerExchangeLockContext> getLockContexts() {
        return this.lockContexts;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientPID(int pid) {
        this.pid = pid;
    }

    @Override
    public int getClientPID() {
        return this.pid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public void addLockContext(ClientServerExchangeLockContext ctxt) {
        this.lockContexts.add(ctxt);
    }

    @Override
    public boolean enterpriseClient() {
        return this.enterpriseClient;
    }

    @Override
    public void setEnterpriseClient(boolean isEnterpriseClient) {
        this.enterpriseClient = isEnterpriseClient;
    }

    @Override
    public long getLocalTimeMills() {
        return this.currentLocalTimeMills;
    }

    @Override
    protected void dehydrateValues() {
        for (ClientServerExchangeLockContext lockContext : this.lockContexts) {
            this.putNVPair((byte)1, lockContext);
        }
        this.putNVPair((byte)3, this.enterpriseClient);
        this.putNVPair((byte)8, this.uuid);
        this.putNVPair((byte)9, this.name);
        this.putNVPair((byte)2, this.clientVersion);
        this.putNVPair((byte)7, this.pid);
        this.putNVPair((byte)4, this.currentLocalTimeMills);
        for (ClientEntityReferenceContext referenceContext : this.reconnectReferences) {
            this.putNVPair((byte)5, referenceContext);
        }
        for (ResendVoltronEntityMessage resendMessage : this.resendMessages) {
            this.putNVPair((byte)6, resendMessage);
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.lockContexts.add(this.getObject(new ClientServerExchangeLockContext()));
                return true;
            }
            case 3: {
                this.enterpriseClient = this.getBooleanValue();
                return true;
            }
            case 2: {
                this.clientVersion = this.getStringValue();
                return true;
            }
            case 4: {
                this.currentLocalTimeMills = this.getLongValue();
                return true;
            }
            case 5: {
                this.reconnectReferences.add(this.getObject(new ClientEntityReferenceContext()));
                return true;
            }
            case 6: {
                this.resendMessages.add(this.getObject(new ResendVoltronEntityMessage()));
                return true;
            }
            case 7: {
                this.pid = this.getIntValue();
                return true;
            }
            case 8: {
                this.uuid = this.getStringValue();
                return true;
            }
            case 9: {
                this.name = this.getStringValue();
                return true;
            }
        }
        return false;
    }

    @Override
    public void addReconnectReference(ClientEntityReferenceContext context) {
        boolean newAddition = this.reconnectReferences.add(context);
        Assert.assertTrue(newAddition);
    }

    @Override
    public Collection<ClientEntityReferenceContext> getReconnectReferences() {
        return this.reconnectReferences;
    }

    @Override
    public void addResendMessage(ResendVoltronEntityMessage message) {
        boolean newAddition = this.resendMessages.add(message);
        Assert.assertTrue(newAddition);
    }

    @Override
    public Collection<ResendVoltronEntityMessage> getResendMessages() {
        return this.resendMessages;
    }
}

