/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonServerStoreProxy.class);
    private final ServerStoreMessageFactory messageFactory;
    private final EhcacheClientEntity entity;
    private final List<ServerStoreProxy.InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<ServerStoreProxy.InvalidationListener>();
    private final Map<Class<? extends EhcacheEntityResponse>, EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>> responseListeners = new ConcurrentHashMap<Class<? extends EhcacheEntityResponse>, EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>>();

    CommonServerStoreProxy(final ServerStoreMessageFactory messageFactory, final EhcacheClientEntity entity) {
        this.messageFactory = messageFactory;
        this.entity = entity;
        this.responseListeners.put(EhcacheEntityResponse.ServerInvalidateHash.class, (EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ServerInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ServerInvalidateHash response) {
                if (response.getCacheId().equals(messageFactory.getCacheId())) {
                    long key = response.getKey();
                    LOGGER.debug("CLIENT: on cache {}, server requesting hash {} to be invalidated", (Object)messageFactory.getCacheId(), (Object)key);
                    for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        this.responseListeners.put(EhcacheEntityResponse.ClientInvalidateHash.class, (EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateHash response) {
                String cacheId = response.getCacheId();
                long key = response.getKey();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                    for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateHash(key);
                    }
                    try {
                        LOGGER.debug("CLIENT: ack'ing invalidation of hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                        entity.invokeAsync(messageFactory.clientInvalidationAck(invalidationId), false);
                    }
                    catch (Exception e) {
                        LOGGER.error("error acking client invalidation of hash {} on cache {}", new Object[]{key, cacheId, e});
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        this.responseListeners.put(EhcacheEntityResponse.ClientInvalidateAll.class, (EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new EhcacheClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateAll>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateAll response) {
                String cacheId = response.getCacheId();
                int invalidationId = response.getInvalidationId();
                if (cacheId.equals(messageFactory.getCacheId())) {
                    LOGGER.debug("CLIENT: doing work to invalidate all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                    for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                        listener.onInvalidateAll();
                    }
                    try {
                        LOGGER.debug("CLIENT: ack'ing invalidation of all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                        entity.invokeAsync(messageFactory.clientInvalidationAck(invalidationId), false);
                    }
                    catch (Exception e) {
                        LOGGER.error("error acking client invalidation of all on cache {}", (Object)cacheId, (Object)e);
                    }
                } else {
                    LOGGER.debug("CLIENT: on cache {}, ignoring invalidation on unrelated cache : {}", (Object)messageFactory.getCacheId(), (Object)response.getCacheId());
                }
            }
        });
        this.addResponseListenersToEntity();
    }

    private void addResponseListenersToEntity() {
        for (Map.Entry<Class<? extends EhcacheEntityResponse>, EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>> classResponseListenerEntry : this.responseListeners.entrySet()) {
            this.entity.addResponseListener(classResponseListenerEntry.getKey(), classResponseListenerEntry.getValue());
        }
    }

    @Override
    public String getCacheId() {
        return this.messageFactory.getCacheId();
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        return this.invalidationListeners.remove(listener);
    }

    <T extends EhcacheEntityResponse> void addResponseListeners(Class<T> listenerClass, EhcacheClientEntity.ResponseListener<T> listener) {
        this.responseListeners.put(listenerClass, listener);
        this.entity.addResponseListener(listenerClass, listener);
    }

    @Override
    public void close() {
        for (Map.Entry<Class<? extends EhcacheEntityResponse>, EhcacheClientEntity.ResponseListener<? extends EhcacheEntityResponse>> classResponseListenerEntry : this.responseListeners.entrySet()) {
            this.entity.removeResponseListener(classResponseListenerEntry.getKey(), classResponseListenerEntry.getValue());
        }
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invoke(this.messageFactory.getOperation(key), false);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for get operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        try {
            this.entity.invoke(this.messageFactory.appendOperation(key, payLoad), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invoke(this.messageFactory.getAndAppendOperation(key, payLoad), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for getAndAppend operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.entity.invokeAsync(this.messageFactory.replaceAtHeadOperation(key, expect, update), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public void clear() throws TimeoutException {
        try {
            this.entity.invoke(this.messageFactory.clearOperation(), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }
}

