/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.CustomerLogging;
import com.tc.logging.LossyTCLogger;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ConnectionAddressIterator;
import com.tc.net.core.ConnectionAddressProvider;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.RestoreConnectionCallback;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientConnectionEstablisher {
    private static final TCLogger LOGGER = TCLogging.getLogger(ClientConnectionEstablisher.class);
    private static final long CONNECT_RETRY_INTERVAL;
    private static final long MIN_RETRY_INTERVAL = 10L;
    public static final String RECONNECT_THREAD_NAME = "ConnectionEstablisher";
    private final String desc;
    private final int maxReconnectTries;
    private final int timeout;
    private final ConnectionAddressProvider connAddressProvider;
    private final TCConnectionManager connManager;
    private final AtomicBoolean asyncReconnecting = new AtomicBoolean(false);
    private final AtomicBoolean allowReconnects = new AtomicBoolean(true);
    private volatile AsyncReconnect asyncReconnect;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;

    public ClientConnectionEstablisher(TCConnectionManager connManager, ConnectionAddressProvider connAddressProvider, int maxReconnectTries, int timeout, ReconnectionRejectedHandler reconnectionRejectedHandler) {
        this.connManager = connManager;
        this.connAddressProvider = connAddressProvider;
        this.maxReconnectTries = maxReconnectTries;
        this.timeout = timeout;
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
        this.asyncReconnect = new AsyncReconnect(this);
        this.desc = maxReconnectTries == 0 ? "none" : (maxReconnectTries < 0 ? "unlimited" : "" + maxReconnectTries);
    }

    public void reset() {
        this.quitReconnectAttempts();
        this.asyncReconnect = new AsyncReconnect(this);
    }

    AsyncReconnect getAsyncReconnectThread() {
        return this.asyncReconnect;
    }

    void setAsyncReconnectingForTests(boolean val) {
        this.asyncReconnecting.set(val);
    }

    void disableReconnectThreadSpawn() {
        this.asyncReconnect.disableThreadSpawn();
    }

    void setAllowReconnects(boolean val) {
        this.allowReconnects.set(val);
    }

    boolean getAllowReconnects() {
        return this.allowReconnects.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(ClientMessageTransport cmt) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        AtomicBoolean atomicBoolean = this.asyncReconnecting;
        synchronized (atomicBoolean) {
            Assert.eval("Can't call open() while asynch reconnect occurring", !this.asyncReconnecting.get());
            this.allowReconnects.set(true);
            this.connectTryAllOnce(cmt);
        }
    }

    void connectTryAllOnce(ClientMessageTransport cmt) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        ConnectionAddressIterator addresses = this.connAddressProvider.getIterator();
        TCConnection rv = null;
        while (addresses.hasNext()) {
            ConnectionInfo connInfo = addresses.next();
            try {
                TCSocketAddress csa = new TCSocketAddress(connInfo);
                rv = this.connect(csa, cmt);
                cmt.openConnection(rv);
                break;
            }
            catch (TCTimeoutException e) {
                if (addresses.hasNext()) continue;
                throw e;
            }
            catch (IOException e) {
                if (addresses.hasNext()) continue;
                throw e;
            }
        }
    }

    TCConnection connect(TCSocketAddress sa, ClientMessageTransport cmt) throws TCTimeoutException, IOException {
        TCConnection connection = this.connManager.createConnection(cmt.getProtocolAdapter());
        cmt.fireTransportConnectAttemptEvent();
        try {
            connection.connect(sa, this.timeout);
        }
        catch (IOException e) {
            connection.close(100L);
            throw e;
        }
        catch (TCTimeoutException e) {
            throw e;
        }
        return connection;
    }

    public String toString() {
        return "ClientConnectionEstablisher[" + this.connAddressProvider + ", timeout=" + this.timeout + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect(ClientMessageTransport cmt) throws MaxConnectionsExceededException {
        try {
            LossyTCLogger connectionErrorLossyLogger = new LossyTCLogger(cmt.getLogger(), 10000L, LossyTCLogger.LossyTCLoggerType.TIME_BASED, true);
            boolean connected = cmt.isConnected();
            if (connected) {
                cmt.getLogger().warn("Got reconnect request for ClientMessageTransport that is connected.  skipping");
                return;
            }
            this.asyncReconnecting.set(true);
            boolean reconnectionRejected = false;
            for (int i = 0; (this.maxReconnectTries < 0 || i < this.maxReconnectTries) && this.isReconnectBetweenL2s() && !connected; ++i) {
                ConnectionAddressIterator addresses = this.connAddressProvider.getIterator();
                while (addresses.hasNext() && !connected && this.isReconnectBetweenL2s()) {
                    if (reconnectionRejected) {
                        if (this.reconnectionRejectedHandler.isRetryOnReconnectionRejected()) {
                            LOGGER.info("Reconnection rejected by L2, trying again to reconnect - " + cmt);
                        } else {
                            LOGGER.info("Reconnection rejected by L2, no more trying to reconnect - " + cmt);
                            return;
                        }
                    }
                    TCConnection connection = null;
                    ConnectionInfo connInfo = addresses.next();
                    if (i == 0) {
                        String previousConnectHost = "";
                        int previousConnectHostPort = -1;
                        if (cmt.getRemoteAddress() != null) {
                            previousConnectHost = cmt.getRemoteAddress().getAddress().getHostAddress();
                            previousConnectHostPort = cmt.getRemoteAddress().getPort();
                        }
                        String connectingToHost = "";
                        try {
                            connectingToHost = this.getHostByName(connInfo);
                        }
                        catch (UnknownHostException e) {
                            this.handleConnectException(e, true, connectionErrorLossyLogger, connection);
                            continue;
                        }
                        int connectingToHostPort = connInfo.getPort();
                        if (addresses.hasNext() && previousConnectHost.equals(connectingToHost) && previousConnectHostPort == connectingToHostPort) continue;
                    }
                    try {
                        if (i % 20 == 0) {
                            cmt.getLogger().warn("Reconnect attempt " + i + " of " + this.desc + " reconnect tries to " + connInfo + ", timeout=" + this.timeout);
                        }
                        connection = this.connect(new TCSocketAddress(connInfo), cmt);
                        cmt.reconnect(connection);
                        connected = true;
                    }
                    catch (MaxConnectionsExceededException e) {
                        throw e;
                    }
                    catch (ReconnectionRejectedException e) {
                        reconnectionRejected = true;
                        this.handleConnectException(e, false, connectionErrorLossyLogger, connection);
                    }
                    catch (TCTimeoutException e) {
                        this.handleConnectException(e, true, connectionErrorLossyLogger, connection);
                    }
                    catch (IOException e) {
                        this.handleConnectException(e, false, connectionErrorLossyLogger, connection);
                    }
                    catch (Exception e) {
                        this.handleConnectException(e, true, connectionErrorLossyLogger, connection);
                    }
                }
            }
        }
        finally {
            this.asyncReconnecting.set(false);
        }
    }

    String getHostByName(ConnectionInfo connInfo) throws UnknownHostException {
        return InetAddress.getByName(connInfo.getHostname()).getHostAddress();
    }

    boolean isReconnectBetweenL2s() {
        return this.reconnectionRejectedHandler.isRetryOnReconnectionRejected() || !this.asyncReconnect.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreConnection(ClientMessageTransport cmt, TCSocketAddress sa, long timeoutMillis, RestoreConnectionCallback callback) throws MaxConnectionsExceededException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        boolean connected = cmt.isConnected();
        if (connected) {
            cmt.getLogger().warn("Got restoreConnection request for ClientMessageTransport that is connected.  skipping");
            return;
        }
        this.asyncReconnecting.set(true);
        try {
            boolean reconnectionRejected = false;
            while (!connected && this.isReconnectBetweenL2s()) {
                if (reconnectionRejected) {
                    if (this.reconnectionRejectedHandler.isRetryOnReconnectionRejected()) {
                        LOGGER.info("Reconnection rejected by L2, trying again to restore connection - " + cmt);
                    } else {
                        LOGGER.info("Reconnection rejected by L2, no more trying to restore connection - " + cmt);
                        return;
                    }
                }
                TCConnection connection = null;
                try {
                    connection = this.connect(sa, cmt);
                    cmt.reconnect(connection);
                    connected = true;
                }
                catch (MaxConnectionsExceededException e) {
                    callback.restoreConnectionFailed(cmt);
                    throw e;
                }
                catch (TCTimeoutException e) {
                    this.handleConnectException(e, true, cmt.getLogger(), connection);
                }
                catch (ReconnectionRejectedException e) {
                    reconnectionRejected = true;
                    this.handleConnectException(e, false, cmt.getLogger(), connection);
                }
                catch (IOException e) {
                    this.handleConnectException(e, false, cmt.getLogger(), connection);
                }
                catch (Exception e) {
                    this.handleConnectException(e, true, cmt.getLogger(), connection);
                }
                if (!connected && System.currentTimeMillis() <= deadline) continue;
                break;
            }
            if (!connected && !reconnectionRejected) {
                callback.restoreConnectionFailed(cmt);
            }
        }
        finally {
            this.asyncReconnecting.set(false);
        }
    }

    private void handleConnectException(Exception e, boolean logFullException, TCLogger logger, TCConnection connection) {
        if (connection != null) {
            connection.close(100L);
        }
        if (logger.isDebugEnabled() || logFullException) {
            logger.error("Connect Exception", e);
        } else {
            logger.warn(e.getMessage());
        }
        if (CONNECT_RETRY_INTERVAL > 0L) {
            try {
                Thread.sleep(CONNECT_RETRY_INTERVAL);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncReconnect(ClientMessageTransport cmt) {
        this.putConnectionRequest(ConnectionRequest.newReconnectRequest(cmt));
    }

    public void asyncRestoreConnection(ClientMessageTransport cmt, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
        this.putConnectionRequest(ConnectionRequest.newRestoreConnectionRequest(cmt, sa, callback, timeoutMillis));
    }

    private void putConnectionRequest(ConnectionRequest request) {
        if (!this.allowReconnects.get() || this.asyncReconnect.isStopped()) {
            LOGGER.info("Ignoring connection request: " + request + " as allowReconnects: " + this.allowReconnects.get() + ", asyncReconnect.isStopped(): " + this.asyncReconnect.isStopped());
            return;
        }
        if (request.getClientMessageTransport() != null && request.getClientMessageTransport().wasOpened()) {
            this.asyncReconnect.putConnectionRequest(request);
        } else {
            LOGGER.info("Ignoring connection request as transport was not connected even once");
        }
    }

    public void quitReconnectAttempts() {
        this.allowReconnects.set(false);
        this.asyncReconnect.stop();
        if (!this.isReconnectBetweenL2s()) {
            this.asyncReconnect.awaitTermination(true);
        }
    }

    int connectionRequestQueueSize() {
        return this.asyncReconnect.connectionRequestQueueSize();
    }

    static {
        TCLogger logger = TCLogging.getLogger(ClientConnectionEstablisher.class);
        long value = TCPropertiesImpl.getProperties().getLong("l1.socket.reconnect.waitInterval");
        if (value < 10L) {
            logger.warn("Forcing reconnect wait interval to 10 (configured value was " + value + ")");
            value = 10L;
        }
        CONNECT_RETRY_INTERVAL = value;
    }

    static class RestoreConnectionRequest
    extends ConnectionRequest {
        private final RestoreConnectionCallback callback;
        private final long timeoutMillis;
        private final TCSocketAddress sa;

        public RestoreConnectionRequest(ClientMessageTransport cmt, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
            super(ConnectionRequestType.RESTORE_CONNECTION, cmt);
            this.callback = callback;
            this.timeoutMillis = timeoutMillis;
            this.sa = sa;
        }

        public TCSocketAddress getSocketAddress() {
            return this.sa;
        }

        public RestoreConnectionCallback getCallback() {
            return this.callback;
        }

        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public String toString() {
            return "RestoreConnectionRequest [type=" + (Object)((Object)this.getType()) + ", clientMessageTransport=" + this.getClientMessageTransport() + ", callback=" + this.callback + ", timeoutMillis=" + this.timeoutMillis + ", sa=" + this.sa + "]";
        }
    }

    static class ConnectionRequest {
        private final ConnectionRequestType type;
        private final ClientMessageTransport cmt;

        public ConnectionRequest(ConnectionRequestType requestType) {
            this(requestType, null);
        }

        public ConnectionRequest(ConnectionRequestType requestType, ClientMessageTransport cmt) {
            this.cmt = cmt;
            this.type = requestType;
        }

        public ConnectionRequestType getType() {
            return this.type;
        }

        public ClientMessageTransport getClientMessageTransport() {
            return this.cmt;
        }

        public static ConnectionRequest newReconnectRequest(ClientMessageTransport cmtParam) {
            return new ConnectionRequest(ConnectionRequestType.RECONNECT, cmtParam);
        }

        public static ConnectionRequest newRestoreConnectionRequest(ClientMessageTransport cmtParam, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
            return new RestoreConnectionRequest(cmtParam, sa, callback, timeoutMillis);
        }

        public String toString() {
            return "ConnectionRequest [type=" + (Object)((Object)this.type) + ", cmt=" + this.cmt + "]";
        }
    }

    static enum ConnectionRequestType {
        RECONNECT,
        RESTORE_CONNECTION;

    }

    static class AsyncReconnect
    implements Runnable {
        private static final TCLogger logger = TCLogging.getLogger(AsyncReconnect.class);
        private final ClientConnectionEstablisher cce;
        private boolean stopped = false;
        private final Queue<ConnectionRequest> connectionRequests = new LinkedList<ConnectionRequest>();
        private Thread connectionEstablisherThread;
        private boolean disableThreadSpawn = false;

        public AsyncReconnect(ClientConnectionEstablisher cce) {
            this.cce = cce;
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        synchronized void disableThreadSpawn() {
            this.disableThreadSpawn = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForThread(Thread oldThread, boolean mayInterruptIfRunning) {
            boolean isInterrupted = false;
            try {
                if (Thread.currentThread() != oldThread && oldThread != null) {
                    if (mayInterruptIfRunning) {
                        oldThread.interrupt();
                    }
                    oldThread.join();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Got interrupted while waiting for connectionEstablisherThread to complete");
                isInterrupted = true;
            }
            finally {
                Util.selfInterruptIfNeeded(isInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitTermination(boolean mayInterruptIfRunning) {
            AsyncReconnect asyncReconnect = this;
            synchronized (asyncReconnect) {
                if (!this.stopped) {
                    throw new AssertionError((Object)"not stopped");
                }
                this.connectionRequests.clear();
                LOGGER.info("waiting for connection establisher to finish " + this.connectionEstablisherThread);
                this.notifyAll();
            }
            this.waitForThread(this.connectionEstablisherThread, mayInterruptIfRunning);
        }

        public synchronized void stop() {
            logger.info("Connection establisher stopping " + System.identityHashCode(this));
            this.stopped = true;
            this.notifyAll();
        }

        public synchronized void putConnectionRequest(ConnectionRequest request) {
            if (!this.stopped) {
                this.startThreadIfNecessary();
                this.connectionRequests.add(request);
                this.notifyAll();
            }
        }

        synchronized int connectionRequestQueueSize() {
            return this.connectionRequests.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized ConnectionRequest waitUntilRequestAvailableOrStopped() {
            boolean isInterrupted = false;
            try {
                while (!this.stopped && this.connectionRequests.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        isInterrupted = true;
                    }
                }
                ConnectionRequest connectionRequest = this.connectionRequests.poll();
                return connectionRequest;
            }
            finally {
                if (isInterrupted) {
                    Util.selfInterruptIfNeeded(isInterrupted);
                }
            }
        }

        private void startThreadIfNecessary() {
            if (this.connectionEstablisherThread == null && !this.disableThreadSpawn) {
                Thread thread = new Thread((Runnable)this, "ConnectionEstablisher-" + this.cce.connAddressProvider.getGroupId() + "-" + System.identityHashCode(this));
                thread.setDaemon(true);
                thread.start();
                this.connectionEstablisherThread = thread;
            }
        }

        @Override
        public void run() {
            logger.info("Connection establisher starting. " + System.identityHashCode(this));
            while (!this.isStopped()) {
                ConnectionRequest request = this.waitUntilRequestAvailableOrStopped();
                if (request != null) {
                    logger.info("Handling connection request: " + request);
                    ClientMessageTransport cmt = request.getClientMessageTransport();
                    try {
                        switch (request.getType()) {
                            case RECONNECT: {
                                this.cce.reconnect(cmt);
                                break;
                            }
                            case RESTORE_CONNECTION: {
                                RestoreConnectionRequest req = (RestoreConnectionRequest)request;
                                this.cce.restoreConnection(req.getClientMessageTransport(), req.getSocketAddress(), req.getTimeoutMillis(), req.getCallback());
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unknown connection request type - " + (Object)((Object)request.getType())));
                            }
                        }
                        continue;
                    }
                    catch (MaxConnectionsExceededException e) {
                        String connInfo = cmt == null ? "" : cmt.getLocalAddress() + "->" + cmt.getRemoteAddress() + " ";
                        CustomerLogging.getConsoleLogger().fatal(connInfo + e.getMessage());
                        if (cmt != null) {
                            cmt.getLogger().warn("No longer trying to reconnect.");
                        }
                        return;
                    }
                    catch (Throwable t) {
                        if (cmt == null) continue;
                        cmt.getLogger().warn("Reconnect failed !", t);
                        continue;
                    }
                }
                if (!this.isStopped()) {
                    throw new AssertionError((Object)"AsyncReconnect not stopped yet, but next request was null");
                }
            }
            logger.info("Connection establisher exiting." + System.identityHashCode(this));
        }
    }
}

