/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.core.ConnectionAddressProvider;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.SecurityInfo;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.AbstractMessageChannel;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.JvmIDUtil;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.session.SessionID;
import com.tc.object.session.SessionProvider;
import com.tc.security.PwProvider;
import com.tc.util.Assert;
import com.tc.util.ProductID;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;

public class ClientMessageChannelImpl
extends AbstractMessageChannel
implements ClientMessageChannel,
ClientHandshakeMessageFactory {
    private static final TCLogger logger = TCLogging.getLogger(ClientMessageChannel.class);
    private int connectAttemptCount;
    private int connectCount;
    private volatile ChannelID channelID = ChannelID.NULL_ID;
    private final SessionProvider sessionProvider;
    private final SecurityInfo securityInfo;
    private final PwProvider pwProvider;
    private volatile SessionID channelSessionID = SessionID.NULL_ID;
    private final ConnectionAddressProvider addressProvider;

    protected ClientMessageChannelImpl(TCMessageFactory msgFactory, TCMessageRouter router, SessionProvider sessionProvider, NodeID remoteNodeID, SecurityInfo securityInfo, PwProvider pwProvider, ConnectionAddressProvider addressProvider, ProductID productId) {
        super(router, logger, msgFactory, remoteNodeID, productId);
        this.securityInfo = securityInfo;
        this.pwProvider = pwProvider;
        this.addressProvider = addressProvider;
        this.sessionProvider = sessionProvider;
        this.sessionProvider.initProvider();
    }

    @Override
    public void reset() {
        this.init();
    }

    protected void init() {
        AbstractMessageChannel.ChannelStatus status = this.getStatus();
        status.reset();
        this.sendLayer.reset();
        this.setLocalNodeID(ClientID.NULL_ID);
    }

    @Override
    public NetworkStackID open() throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        return this.open(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStackID open(char[] pw) throws TCTimeoutException, UnknownHostException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        AbstractMessageChannel.ChannelStatus status;
        AbstractMessageChannel.ChannelStatus channelStatus = status = this.getStatus();
        synchronized (channelStatus) {
            if (status.isOpen()) {
                throw new IllegalStateException("Channel already open");
            }
            String username = null;
            if (this.securityInfo.hasCredentials()) {
                username = this.securityInfo.getUsername();
                Assert.assertNotNull("TCSecurityManager", this.pwProvider);
                Assert.assertNotNull("Password", pw);
            }
            ConnectionID cid = new ConnectionID(JvmIDUtil.getJvmID(), ((ClientID)this.getLocalNodeID()).toLong(), username, pw, this.getProductId());
            ((MessageTransport)this.sendLayer).initConnectionID(cid);
            NetworkStackID id = this.sendLayer.open();
            this.channelID = new ChannelID(id.toLong());
            this.setLocalNodeID(new ClientID(id.toLong()));
            this.channelSessionID = this.sessionProvider.getSessionID();
            this.channelOpened();
            return id;
        }
    }

    @Override
    public void reopen() throws Exception {
        this.reset();
        this.open(this.getPassword());
    }

    public char[] getPassword() {
        char[] password = null;
        if (this.securityInfo.hasCredentials()) {
            Assert.assertNotNull("TCSecurityManager should not be null", this.pwProvider);
            ConnectionInfo connectionInfo = this.addressProvider.getIterator().next();
            password = this.pwProvider.getPasswordForTC(this.securityInfo.getUsername(), connectionInfo.getHostname(), connectionInfo.getPort());
            Assert.assertNotNull("password is null from securityInfo " + this.securityInfo, password);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelID getChannelID() {
        AbstractMessageChannel.ChannelStatus status;
        AbstractMessageChannel.ChannelStatus channelStatus = status = this.getStatus();
        synchronized (channelStatus) {
            if (!status.isOpen()) {
                logger.warn("Attempt to get the channel ID of an unopened channel - " + this.channelID);
            }
            return this.channelID;
        }
    }

    @Override
    public int getConnectCount() {
        return this.connectCount;
    }

    @Override
    public int getConnectAttemptCount() {
        return this.connectAttemptCount;
    }

    @Override
    public void send(TCNetworkMessage message) throws IOException {
        super.send(message);
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        long channelIdLong = transport.getConnectionId().getChannelID();
        this.channelID = new ChannelID(channelIdLong);
        this.setLocalNodeID(new ClientID(channelIdLong));
        super.notifyTransportConnected(transport);
        ++this.connectCount;
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.channelSessionID = this.sessionProvider.nextSessionID();
        logger.info("ClientMessageChannel moves to " + this.channelSessionID + " for remote node " + this.getRemoteNodeID());
        super.notifyTransportDisconnected(transport, forcedDisconnect);
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        super.notifyTransportConnectAttempt(transport);
        ++this.connectAttemptCount;
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getLocalNodeID();
    }

    @Override
    public ClientHandshakeMessage newClientHandshakeMessage(String uuid, String name, String clientVersion, boolean isEnterpriseClient) {
        ClientHandshakeMessage rv = (ClientHandshakeMessage)this.createMessage(TCMessageType.CLIENT_HANDSHAKE_MESSAGE);
        rv.setClientVersion(clientVersion);
        rv.setEnterpriseClient(isEnterpriseClient);
        rv.setClientPID(this.getPID());
        rv.setUUID(uuid);
        rv.setName(name);
        return rv;
    }

    @Override
    public ClientHandshakeMessageFactory getClientHandshakeMessageFactory() {
        return this;
    }

    private int getPID() {
        String vmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = vmName.indexOf(64);
        if (index < 0) {
            throw new RuntimeException("unexpected format: " + vmName);
        }
        return Integer.parseInt(vmName.substring(0, index));
    }
}

