/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.net.protocol.AbstractNetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarness;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.ConnectionWatcher;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.net.protocol.transport.MessageTransportListener;

public class PlainNetworkStackHarnessFactory
implements NetworkStackHarnessFactory {
    private final boolean allowConnectionReplace;

    public PlainNetworkStackHarnessFactory() {
        this(false);
    }

    public PlainNetworkStackHarnessFactory(boolean allowConnectionReplace) {
        this.allowConnectionReplace = allowConnectionReplace;
    }

    @Override
    public NetworkStackHarness createServerHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport, MessageTransportListener[] transportListeners) {
        return new PlainNetworkStackHarness(channelFactory, transport);
    }

    @Override
    public NetworkStackHarness createClientHarness(MessageTransportFactory transportFactory, MessageChannelInternal channel, MessageTransportListener[] transportListeners) {
        return new PlainNetworkStackHarness(transportFactory, channel);
    }

    private class PlainNetworkStackHarness
    extends AbstractNetworkStackHarness {
        PlainNetworkStackHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport) {
            super(channelFactory, transport);
        }

        PlainNetworkStackHarness(MessageTransportFactory transportFactory, MessageChannelInternal channel) {
            super(transportFactory, channel);
        }

        @Override
        protected void connectStack() {
            this.channel.setSendLayer(this.transport);
            this.transport.setReceiveLayer(this.channel);
            this.transport.setAllowConnectionReplace(PlainNetworkStackHarnessFactory.this.allowConnectionReplace);
            if (this.transport instanceof ClientMessageTransport) {
                ClientMessageTransport cmt = (ClientMessageTransport)this.transport;
                ClientConnectionEstablisher cce = cmt.getConnectionEstablisher();
                ConnectionWatcher cw = new ConnectionWatcher(cmt, this.channel, cce);
                this.transport.addTransportListener(cw);
            } else {
                this.transport.addTransportListener(this.channel);
            }
        }

        @Override
        protected void createIntermediateLayers() {
        }
    }
}

