/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.ConfigurationContext;
import com.tc.async.api.Stage;
import com.tc.util.State;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class StageController {
    private final Map<State, Set<String>> states = new HashMap<State, Set<String>>();

    public synchronized void addStageToState(State state, String stage) {
        Set<String> list = this.states.get(state);
        if (list == null) {
            list = new LinkedHashSet<String>();
            this.states.put(state, list);
        }
        list.add(stage);
    }

    public synchronized void removeStageFromState(State state, String stage) {
        Set<String> list = this.states.get(state);
        if (list != null) {
            list.remove(stage);
        }
    }

    public void transition(ConfigurationContext cxt, State old, State current) {
        Stage<Object> st;
        Set<String> leaving = this.states.get(old);
        Set<String> coming = this.states.get(current);
        if (leaving == null) {
            leaving = Collections.emptySet();
        }
        if (coming == null) {
            coming = Collections.emptySet();
        }
        for (String s : leaving) {
            st = cxt.getStage(s, Object.class);
            if (st == null || coming.contains(s)) continue;
            st.destroy();
        }
        for (String s : coming) {
            st = cxt.getStage(s, Object.class);
            if (st == null || leaving.contains(s)) continue;
            st.start(cxt);
            st.unpause();
        }
    }
}

