/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.encoding.dataholders;

import java.nio.ByteBuffer;
import org.terracotta.runnel.encoding.dataholders.AbstractDataHolder;
import org.terracotta.runnel.utils.StringTool;
import org.terracotta.runnel.utils.WriteBuffer;

public final class StringDataHolder
extends AbstractDataHolder {
    private static final boolean V1_STRING_ENCODING = false;
    private final ByteBuffer encodedString;

    public StringDataHolder(String value, int index) {
        super(index);
        this.encodedString = this.encodeString(value);
    }

    @Override
    protected int valueSize() {
        return this.encodedString.remaining();
    }

    @Override
    protected void encodeValue(WriteBuffer writeBuffer) {
        writeBuffer.putByteBuffer(this.encodedString);
    }

    private ByteBuffer encodeString(String object) {
        ByteBuffer w = ByteBuffer.allocate(4 * object.length() + 1);
        StringTool.putEncoded(w, object, object.length());
        w.flip();
        return w.slice();
    }
}

