/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.common.struct.TimeBudget;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.lease.LeaseMaintainer;
import org.terracotta.lease.LeaseMaintainerFactory;
import org.terracotta.lease.TimeSource;
import org.terracotta.lease.connection.LeasedConnection;

public class BasicLeasedConnection
implements LeasedConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicLeasedConnection.class);
    private final Connection base;
    private final LeaseMaintainer leaseMaintainer;

    public static BasicLeasedConnection create(Connection connection, TimeBudget timeBudget, TimeSource timeSource) throws ConnectionException {
        LeaseMaintainer leaseMaintainer = LeaseMaintainerFactory.createLeaseMaintainer(connection, timeSource);
        Exception exception = null;
        try {
            boolean leased = leaseMaintainer.waitForLease(timeBudget.remaining(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            if (!leased) {
                exception = new IOException("Unable to acquire lease for connection before connection timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            exception = e;
        }
        if (exception != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close connection that we failed to get a lease on", (Throwable)e);
            }
            throw new ConnectionException(exception);
        }
        return new BasicLeasedConnection(connection, leaseMaintainer);
    }

    private BasicLeasedConnection(Connection base, LeaseMaintainer leaseMaintainer) {
        this.base = base;
        this.leaseMaintainer = leaseMaintainer;
    }

    @Override
    public <T extends Entity, C, U> EntityRef<T, C, U> getEntityRef(Class<T> cls, long version, String name) throws EntityNotProvidedException {
        return this.base.getEntityRef(cls, version, name);
    }

    @Override
    public void close() throws IOException {
        this.leaseMaintainer.destroy();
    }

    @Override
    public boolean isValid() {
        return this.base.isValid();
    }
}

