/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.BaseCodec;
import org.ehcache.clustered.common.internal.messages.ConfigCodec;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.LifecycleMessage;
import org.ehcache.clustered.common.internal.messages.MessageCodecUtils;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class LifeCycleMessageCodec {
    private static final String CONFIG_PRESENT_FIELD = "configPresent";
    private static final int CONFIGURE_MESSAGE_NEXT_INDEX = 40;
    private static final int VALIDATE_STORE_NEXT_INDEX = 40;
    private final Struct PREPARE_FOR_DESTROY_STRUCT = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).build();
    private final Struct validateMessageStruct;
    private final Struct validateStoreMessageStruct;
    private final ConfigCodec configCodec;

    public LifeCycleMessageCodec(ConfigCodec configCodec) {
        this.configCodec = configCodec;
        StructBuilder validateMessageStructBuilderPrefix = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).bool(CONFIG_PRESENT_FIELD, 30);
        this.validateMessageStruct = this.configCodec.injectServerSideConfiguration(validateMessageStructBuilderPrefix, 40).getUpdatedBuilder().build();
        StructBuilder validateStoreMessageStructBuilderPrefix = StructBuilder.newStructBuilder().enm("opCode", 10, BaseCodec.EHCACHE_MESSAGE_TYPES_ENUM_MAPPING).string("serverStoreName", 30);
        this.validateStoreMessageStruct = this.configCodec.injectServerStoreConfiguration(validateStoreMessageStructBuilderPrefix, 40).getUpdatedBuilder().build();
    }

    public byte[] encode(LifecycleMessage message) {
        switch (message.getMessageType()) {
            case VALIDATE: {
                return this.encodeTierManagerValidateMessage((LifecycleMessage.ValidateStoreManager)message);
            }
            case VALIDATE_SERVER_STORE: {
                return this.encodeValidateStoreMessage((LifecycleMessage.ValidateServerStore)message);
            }
            case PREPARE_FOR_DESTROY: {
                return this.encodePrepareForDestroyMessage(message);
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle message: " + message.getClass());
    }

    private byte[] encodePrepareForDestroyMessage(LifecycleMessage message) {
        return MessageCodecUtils.encodeMandatoryFields(this.PREPARE_FOR_DESTROY_STRUCT, message).encode().array();
    }

    private byte[] encodeValidateStoreMessage(LifecycleMessage.ValidateServerStore message) {
        StructEncoder<Void> encoder = MessageCodecUtils.encodeMandatoryFields(this.validateStoreMessageStruct, message);
        encoder.string("serverStoreName", message.getName());
        this.configCodec.encodeServerStoreConfiguration(encoder, message.getStoreConfiguration());
        return encoder.encode().array();
    }

    private byte[] encodeTierManagerValidateMessage(LifecycleMessage.ValidateStoreManager message) {
        StructEncoder<Void> encoder = MessageCodecUtils.encodeMandatoryFields(this.validateMessageStruct, message);
        ServerSideConfiguration config = message.getConfiguration();
        if (config == null) {
            encoder.bool(CONFIG_PRESENT_FIELD, false);
        } else {
            encoder.bool(CONFIG_PRESENT_FIELD, true);
            this.configCodec.encodeServerSideConfiguration(encoder, config);
        }
        return encoder.encode().array();
    }

    public EhcacheEntityMessage decode(EhcacheMessageType messageType, ByteBuffer messageBuffer) {
        switch (messageType) {
            case VALIDATE: {
                return this.decodeValidateMessage(messageBuffer);
            }
            case VALIDATE_SERVER_STORE: {
                return this.decodeValidateServerStoreMessage(messageBuffer);
            }
            case PREPARE_FOR_DESTROY: {
                return this.decodePrepareForDestroyMessage();
            }
        }
        throw new IllegalArgumentException("LifeCycleMessage operation not defined for : " + messageType);
    }

    private LifecycleMessage.PrepareForDestroy decodePrepareForDestroyMessage() {
        return new LifecycleMessage.PrepareForDestroy();
    }

    private LifecycleMessage.ValidateServerStore decodeValidateServerStoreMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateStoreMessageStruct.decoder(messageBuffer);
        String storeName = decoder.string("serverStoreName");
        ServerStoreConfiguration config = this.configCodec.decodeServerStoreConfiguration(decoder);
        return new LifecycleMessage.ValidateServerStore(storeName, config);
    }

    private LifecycleMessage.ValidateStoreManager decodeValidateMessage(ByteBuffer messageBuffer) {
        StructDecoder<Void> decoder = this.validateMessageStruct.decoder(messageBuffer);
        boolean configPresent = decoder.bool(CONFIG_PRESENT_FIELD);
        ServerSideConfiguration config = null;
        if (configPresent) {
            config = this.configCodec.decodeServerSideConfiguration(decoder);
        }
        return new LifecycleMessage.ValidateStoreManager(config);
    }
}

