/*
 * Decompiled with CFR 0.152.
 */
package com.tc.bytes;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCReference;
import com.tc.bytes.TCReferenceSupport;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;

public class TCByteBufferAllocator {
    private final Supplier<TCByteBuffer> newBuffers;
    private final Queue<TCByteBuffer> returns;
    private final List<TCByteBuffer> items = new ArrayList<TCByteBuffer>();
    private final SetOnceFlag complete = new SetOnceFlag();

    public TCByteBufferAllocator(Supplier<TCByteBuffer> tracked) {
        this(tracked, new LinkedList<TCByteBuffer>());
    }

    public TCByteBufferAllocator(Supplier<TCByteBuffer> tracked, Queue<TCByteBuffer> returns) {
        this.newBuffers = tracked;
        this.returns = returns;
    }

    public TCByteBuffer add() {
        if (this.complete.isSet()) {
            throw new IllegalStateException("buffers already accessed");
        }
        TCByteBuffer next = this.returns.poll();
        if (next == null) {
            next = this.newBuffers.get();
        }
        this.items.add(next);
        return next;
    }

    private void reset(int stop) {
        if (this.complete.isSet()) {
            throw new IllegalStateException("buffers already accessed");
        }
        Iterator<TCByteBuffer> it = this.items.iterator();
        int pos = 0;
        while (it.hasNext()) {
            TCByteBuffer c = it.next();
            if (c.position() + pos < stop) {
                pos += c.position();
                continue;
            }
            if (pos < stop) {
                c.position(stop - pos);
                continue;
            }
            it.remove();
            this.returns.add(c.reInit());
        }
    }

    public void rewind(int r) {
        int len = this.items.stream().mapToInt(TCByteBuffer::position).sum();
        this.reset(len - r);
    }

    public TCReference complete() {
        this.complete.set();
        return TCReferenceSupport.createReference(this.items, this.returns::add);
    }
}

