/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SimpleRingBuffer<T>
implements Iterable<T> {
    private final Object[] buffer;
    private int head = 0;

    public SimpleRingBuffer(int size) {
        this.buffer = new Object[size];
        this.head = 0;
    }

    public void put(T item) {
        Objects.requireNonNull(item);
        this.buffer[this.head++] = item;
        this.head %= this.buffer.length;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.buffer[0] == null) {
            return Collections.emptyIterator();
        }
        final Object[] ref = this.buffer[this.head] != null ? Arrays.copyOf(this.buffer, this.buffer.length) : Arrays.copyOf(this.buffer, this.head);
        final int pivot = this.head != ref.length ? this.head : 0;
        return new Iterator<T>(){
            private int pos;
            boolean done;
            {
                this.pos = pivot;
                this.done = false;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                Object object;
                try {
                    object = ref[this.pos++];
                }
                catch (Throwable throwable) {
                    this.pos %= ref.length;
                    this.done = this.pos == pivot;
                    throw throwable;
                }
                this.pos %= ref.length;
                this.done = this.pos == pivot;
                return object;
            }
        };
    }
}

