/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.async.api.Sink;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageSink;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCMessageHydrateAndConvertSink<T, C>
implements TCMessageSink {
    private final Sink<C> destSink;
    private final Function<T, C> converter;
    private static final Logger LOGGER = LoggerFactory.getLogger(TCMessageHydrateAndConvertSink.class);

    public TCMessageHydrateAndConvertSink(Sink<C> destSink, Function<T, C> f) {
        this.destSink = destSink;
        this.converter = f;
    }

    @Override
    public void putMessage(TCAction message) {
        try {
            message.hydrate();
            C converted = this.converter.apply(message);
            if (converted != null) {
                this.destSink.addToSink(converted);
            }
        }
        catch (Throwable t) {
            try {
                LOGGER.error("Error hydrating message of type " + message.getMessageType(), t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            message.getChannel().close();
            return;
        }
    }
}

