/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.exception.TCRuntimeException;
import com.tc.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class HexDump {
    private static final int BYTES_PER_LINE = 16;

    public static String dump(byte[] data) {
        return HexDump.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int length) {
        try {
            StringWriter writer = new StringWriter();
            HexDump.dump(data, offset, length, writer);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new TCRuntimeException("How'd we get an IOException with an in-memory stream?", ioe);
        }
    }

    public static void dump(byte[] data, Writer out) throws IOException {
        HexDump.dump(data, 0, data.length, out);
    }

    public static void dump(byte[] data, int offset, int length, Writer out) throws IOException {
        Assert.assertNotNull(data);
        Assert.assertNotNull(out);
        Assert.eval(offset >= 0);
        Assert.eval(offset + length <= data.length);
        Assert.eval(length >= 0);
        boolean multiline = length > 16;
        byte[] thisLine = new byte[16];
        out.write(length + " byte" + (length == 1 ? "" : "s") + ":");
        if (multiline) {
            out.write("\n");
        } else {
            out.write(" ");
        }
        int linePos = 0;
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0 && multiline) {
                if (i != 0) {
                    out.write("\n");
                }
                out.write(HexDump.padHex(i, 8) + ":");
                linePos = 0;
            }
            byte b = data[offset + i];
            thisLine[linePos++] = b;
            if (i % 2 == 0 && (multiline || i != 0)) {
                out.write(" ");
            }
            out.write(HexDump.padHex(b & 0xFF, 2));
            if (i == length - 1) {
                int onLastLine = length - length / 16 * 16;
                if (onLastLine == 0) {
                    onLastLine = 16;
                }
                int remaining = 16 - onLastLine;
                if (multiline) {
                    if (remaining == 0) {
                        out.write(" ");
                    }
                    if (remaining % 2 != 0) {
                        out.write("   ");
                        --remaining;
                    }
                    Assert.eval(remaining % 2 == 0);
                    while (remaining > 0) {
                        out.write("     ");
                        remaining -= 2;
                    }
                    out.write(" ");
                } else {
                    out.write("  ");
                }
                for (int j = 0; j < onLastLine; ++j) {
                    out.write(HexDump.getChar(thisLine[j]));
                }
                if (!multiline) continue;
                out.write("\n");
                continue;
            }
            if ((i + 1) % 16 != 0 || i == 0) continue;
            out.write("  ");
            for (int j = 0; j < thisLine.length; ++j) {
                out.write(HexDump.getChar(thisLine[j]));
            }
        }
    }

    public static String rawHexDump(byte[] data) {
        StringBuffer hexDump = new StringBuffer();
        for (int pos = 0; pos < data.length; ++pos) {
            hexDump.append(HexDump.padHex(0xFF & data[pos], 2));
        }
        return hexDump.toString();
    }

    private static char getChar(byte b) {
        int val = b & 0xFF;
        if (val < 32 || val > 126) {
            return '.';
        }
        return (char)b;
    }

    private static String padHex(int num, int totalLength) {
        Object out = Integer.toHexString(num);
        while (((String)out).length() < totalLength) {
            out = "0" + (String)out;
        }
        return out;
    }
}

