/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.NodeID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.NetworkLayer;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.tcm.ChannelEventImpl;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ChannelEventType;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.TCAction;
import com.tc.net.protocol.tcm.TCMessageFactory;
import com.tc.net.protocol.tcm.TCMessageParser;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;

abstract class AbstractMessageChannel
implements MessageChannelInternal {
    private final ConcurrentMap<String, Object> attachments = new ConcurrentHashMap<String, Object>();
    private final Set<ChannelEventListener> listeners = new CopyOnWriteArraySet<ChannelEventListener>();
    private final ChannelStatus status = new ChannelStatus();
    private final TCMessageFactory msgFactory;
    private final TCMessageRouter router;
    private final TCMessageParser parser;
    private final Logger logger;
    private volatile NodeID localNodeID;
    protected volatile NetworkLayer sendLayer;

    AbstractMessageChannel(TCMessageRouter router, Logger logger, TCMessageFactory msgFactory) {
        this.router = router;
        this.logger = logger;
        this.msgFactory = msgFactory;
        this.parser = new TCMessageParser(this.msgFactory);
        this.localNodeID = ClientID.NULL_ID;
    }

    @Override
    public NetworkStackID open(InetSocketAddress serverAddress) throws MaxConnectionsExceededException, TCTimeoutException, UnknownHostException, IOException, CommStackMismatchException {
        return this.open(Collections.singleton(serverAddress));
    }

    @Override
    public void addAttachment(String key, Object value, boolean replace) {
        if (replace) {
            this.attachments.put(key, value);
        } else {
            this.attachments.putIfAbsent(key, value);
        }
    }

    @Override
    public Object removeAttachment(String key) {
        return this.attachments.remove(key);
    }

    @Override
    public Object getAttachment(String key) {
        return this.attachments.get(key);
    }

    @Override
    public boolean isOpen() {
        return this.status.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.status.isClosed();
    }

    @Override
    public void addListener(ChannelEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public NodeID getLocalNodeID() {
        return this.localNodeID;
    }

    @Override
    public void setLocalNodeID(NodeID localNodeID) {
        this.localNodeID = localNodeID;
    }

    @Override
    public TCAction createMessage(TCMessageType type) {
        TCAction rv = this.msgFactory.createMessage(this, type, this.createOutput());
        return rv;
    }

    @Override
    public TCByteBufferOutputStream createOutput() {
        return this.sendLayer.createOutput();
    }

    private void fireChannelOpenedEvent() {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.CHANNEL_OPENED_EVENT, this));
    }

    private void fireChannelClosedEvent() {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.CHANNEL_CLOSED_EVENT, this));
    }

    public void addClassMapping(TCMessageType type, Class<? extends TCAction> msgClass) {
        this.msgFactory.addClassMapping(type, msgClass);
    }

    void channelOpened() {
        this.status.open();
        this.fireChannelOpenedEvent();
    }

    @Override
    public void close() {
        if (!this.status.getAndSetIsClosed()) {
            Assert.assertNotNull(this.sendLayer);
            this.sendLayer.close();
            this.fireChannelClosedEvent();
        }
    }

    @Override
    public boolean isConnected() {
        return this.sendLayer != null && this.sendLayer.isConnected();
    }

    @Override
    public final void setSendLayer(NetworkLayer layer) {
        this.sendLayer = layer;
    }

    @Override
    public final void setReceiveLayer(NetworkLayer layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NetworkLayer getReceiveLayer() {
        return null;
    }

    @Override
    public void send(TCNetworkMessage message) throws IOException {
        if (this.logger.isDebugEnabled()) {
            message.addCompleteCallback(() -> this.logger.debug("Message Sent: " + message.toString()));
        }
        this.sendLayer.send(message);
    }

    @Override
    public final void receive(TCNetworkMessage msgData) {
        this.router.putMessage(this.parser.parseMessage(this, msgData));
    }

    protected final ChannelStatus getStatus() {
        return this.status;
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.TRANSPORT_DISCONNECTED_EVENT, this));
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.TRANSPORT_CONNECTED_EVENT, this));
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.TRANSPORT_CLOSED_EVENT, this));
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.fireEvent(new ChannelEventImpl(ChannelEventType.TRANSPORT_RECONNECTION_REJECTED_EVENT, this));
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        NetworkLayer sendLyr = this.sendLayer;
        if (sendLyr != null) {
            return sendLyr.getLocalAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        NetworkLayer sendLyr = this.sendLayer;
        if (sendLyr != null) {
            return sendLyr.getRemoteAddress();
        }
        return null;
    }

    private void fireEvent(ChannelEventImpl event) {
        for (ChannelEventListener listener : this.listeners) {
            listener.notifyChannelEvent(event);
        }
    }

    @Override
    public short getStackLayerFlag() {
        return 4;
    }

    @Override
    public String getStackLayerName() {
        return "Channel Layer";
    }

    public String toString() {
        return this.getChannelID() + ":" + this.getLocalAddress() + " <--> " + this.getRemoteAddress();
    }

    protected ProductID getProductID(ProductID defaultID) {
        if (this.sendLayer != null) {
            return this.sendLayer.getConnectionID().getProductId();
        }
        return defaultID;
    }

    @Override
    public ConnectionID getConnectionID() {
        if (this.sendLayer != null) {
            return this.sendLayer.getConnectionID();
        }
        return ConnectionID.NULL_ID;
    }

    @Override
    public ChannelID getChannelID() {
        return new ChannelID(this.getConnectionID().getChannelID());
    }

    @Override
    public SessionID getSessionID() {
        return this.sendLayer.getSessionID();
    }

    protected NetworkLayer getSendLayer() {
        return this.sendLayer;
    }

    class ChannelStatus {
        private ChannelState state = ChannelState.INIT;

        synchronized void reset() {
            this.state = ChannelState.INIT;
        }

        synchronized void open() {
            Assert.assertTrue("Switch only from init state to open state", ChannelState.INIT.equals((Object)this.state));
            this.state = ChannelState.OPEN;
        }

        synchronized boolean getAndSetIsClosed() {
            if (ChannelState.INIT.equals((Object)this.state)) {
                AbstractMessageChannel.this.logger.debug("Switching channel state from " + ChannelState.INIT + " to " + ChannelState.CLOSED + ".");
                this.state = ChannelState.CLOSED;
                return true;
            }
            if (ChannelState.CLOSED.equals((Object)this.state)) {
                return true;
            }
            this.state = ChannelState.CLOSED;
            return false;
        }

        synchronized boolean isOpen() {
            return ChannelState.OPEN.equals((Object)this.state);
        }

        synchronized boolean isClosed() {
            return ChannelState.CLOSED.equals((Object)this.state);
        }

        public String toString() {
            return "Status:" + this.state.toString();
        }
    }

    private static enum ChannelState {
        INIT,
        OPEN,
        CLOSED;

    }
}

