/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.BinaryInvocationCallback;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.InFlightStats;
import com.tc.object.InvocationHandler;
import com.tc.object.SafeInvocationCallback;
import com.tc.util.Assert;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.Invocation;
import org.terracotta.entity.InvocationCallback;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EntityClientEndpointImpl<M extends EntityMessage, R extends EntityResponse>
implements EntityClientEndpoint<M, R> {
    private static Logger LOGGER = LoggerFactory.getLogger(EntityClientEndpointImpl.class);
    private final InvocationHandler invocationHandler;
    private final byte[] configuration;
    private final EntityDescriptor invokeDescriptor;
    private final EntityID entityID;
    private final long version;
    private final MessageCodec<M, R> codec;
    private final Callable<Void> closeHook;
    private final ExecutorService closer;
    private EndpointDelegate<R> delegate;
    private boolean isOpen;
    private Future<Void> releaseFuture;
    private final InFlightStats stats = new InFlightStats();

    public EntityClientEndpointImpl(EntityID eid, long version, EntityDescriptor instance, InvocationHandler invocationHandler, byte[] entityConfiguration, MessageCodec<M, R> codec, Callable<Void> closeHook, ExecutorService closer) {
        this.entityID = eid;
        this.version = version;
        this.invokeDescriptor = instance;
        this.invocationHandler = invocationHandler;
        this.configuration = entityConfiguration;
        this.codec = codec;
        this.closeHook = closeHook;
        this.closer = closer;
        this.isOpen = true;
    }

    EntityID getEntityID() {
        return this.entityID;
    }

    long getVersion() {
        return this.version;
    }

    EntityDescriptor getEntityDescriptor() {
        return this.invokeDescriptor;
    }

    @Override
    public byte[] getEntityConfiguration() {
        this.checkEndpointOpen();
        return this.configuration;
    }

    @Override
    public void setDelegate(EndpointDelegate<R> delegate) {
        this.checkEndpointOpen();
        Assert.assertNull(this.delegate);
        this.delegate = delegate;
    }

    public void handleMessage(byte[] message) throws MessageCodecException {
        if (null != this.delegate) {
            R messageFromServer = this.codec.decodeResponse(message);
            this.delegate.handleMessage(messageFromServer);
        }
    }

    public InFlightStats getStatistics() {
        return this.stats;
    }

    @Override
    public Invocation<R> message(M message) {
        this.checkEndpointOpen();
        return new InvocationImpl(this, (EntityMessage)message);
    }

    public byte[] getExtendedReconnectData() {
        byte[] reconnectData = null;
        if (null != this.delegate) {
            reconnectData = this.delegate.createExtendedReconnectData();
        }
        if (null == reconnectData) {
            reconnectData = new byte[]{};
        }
        return reconnectData;
    }

    @Override
    public void close() {
        if (this.closeIfOpen() && this.closeHook != null) {
            try {
                this.closeHook.call();
            }
            catch (Exception e) {
                LOGGER.warn("Exception occured during close", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Future<Void> release() {
        if (this.releaseFuture == null) {
            if (this.closer == null) {
                this.close();
                this.releaseFuture = CompletableFuture.completedFuture(null);
            } else {
                try {
                    Callable<Void> call = new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            EntityClientEndpointImpl.this.close();
                            return null;
                        }
                    };
                    this.releaseFuture = this.closer.submit(call);
                }
                catch (RejectedExecutionException re) {
                    LOGGER.debug("connection already closed", (Throwable)re);
                    this.releaseFuture = CompletableFuture.completedFuture(null);
                }
            }
        }
        return this.releaseFuture;
    }

    public void didCloseUnexpectedly() {
        if (null != this.delegate) {
            this.delegate.didDisconnectUnexpectedly();
        }
    }

    private synchronized void checkEndpointOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Endpoint closed");
        }
    }

    private synchronized boolean closeIfOpen() {
        boolean wasOpen = this.isOpen;
        this.isOpen = false;
        return wasOpen;
    }

    private static class InvocationImpl
    implements Invocation<R> {
        private boolean invoked = false;
        private final M request;
        final /* synthetic */ EntityClientEndpointImpl this$0;

        private InvocationImpl(M request) {
            this.this$0 = var1_1;
            this.request = request;
        }

        @Override
        public Invocation.Task invoke(InvocationCallback<R> callback, Set<InvocationCallback.Types> callbacks) {
            this.checkInvoked();
            this.invoked = true;
            BinaryInvocationCallback binaryCallback = new BinaryInvocationCallback(this.this$0.codec, SafeInvocationCallback.safe(callback));
            try {
                return this.this$0.invocationHandler.invokeAction(this.this$0.entityID, this.this$0.invokeDescriptor, callbacks, binaryCallback, true, this.this$0.codec.encodeMessage(this.request));
            }
            catch (MessageCodecException e) {
                binaryCallback.failure(e);
                binaryCallback.complete();
                binaryCallback.retired();
                return () -> false;
            }
        }

        private void checkInvoked() {
            if (this.invoked) {
                throw new IllegalStateException("Already invoked");
            }
        }
    }
}

