/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.util.concurrent.SetOnceFlag;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionWatcher
implements MessageTransportListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionWatcher.class);
    private volatile ConnectionID connection;
    private final ClientConnectionEstablisher cce;
    private final ReferenceQueue<ClientMessageChannel> stopQueue = new ReferenceQueue();
    private final SetOnceFlag stopped = new SetOnceFlag();
    private final WeakReference<ClientMessageChannel> targetHolder;

    public ConnectionWatcher(ClientMessageChannel target, ClientConnectionEstablisher cce) {
        this.targetHolder = new WeakReference<ClientMessageChannel>(target, this.stopQueue);
        this.cce = cce;
        this.connection = target.getConnectionID();
    }

    private boolean checkForStop() {
        Reference<ClientMessageChannel> target = this.stopQueue.poll();
        while (target != null) {
            if (target == this.targetHolder) {
                this.stopped.set();
                LOGGER.warn("unreferenced connection left open {} {}", this.targetHolder.get(), (Object)this.connection);
                this.cce.shutdown();
            }
            target = this.stopQueue.poll();
        }
        return this.stopped.isSet();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.cce.shutdown();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportClosed(transport);
        }
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (transport.getProductID().isReconnectEnabled()) {
            this.cce.asyncReconnect(this::checkForStop);
        } else {
            this.cce.shutdown();
        }
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportDisconnected(transport, forcedDisconnect);
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnectAttempt(transport);
        }
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.connection = transport.getConnectionID();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportConnected(transport);
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        this.cce.shutdown();
        MessageTransportListener target = (MessageTransportListener)this.targetHolder.get();
        if (target != null) {
            target.notifyTransportReconnectionRejected(transport);
        }
    }
}

