/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.ehcache.xml.BaseConfigParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ClusteringParser<T>
extends BaseConfigParser<T> {
    protected static final String NAMESPACE = "http://www.ehcache.org/v3/clustered";
    protected static final String TC_CLUSTERED_NAMESPACE_PREFIX = "tc:";

    public ClusteringParser() {
        this(Collections.emptyMap());
    }

    public ClusteringParser(Map<URI, URL> namespaces) {
        super((Map)Stream.concat(Collections.singletonMap(URI.create(NAMESPACE), ClusteringParser.class.getResource("/ehcache-clustered-ext.xsd")).entrySet().stream(), namespaces.entrySet().stream()).collect(ClusteringParser.toLinkedHashMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    protected static Optional<Element> childElementOf(Element fragment, Predicate<Element> predicate) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList children = fragment.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !predicate.test((Element)child)) continue;
            elements.add((Element)child);
        }
        switch (elements.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(elements.iterator().next());
            }
        }
        throw new AssertionError((Object)("Validation Leak! {" + elements + "}"));
    }

    protected static <T extends Node> Optional<T> optionalSingleton(Class<T> nodeKlass, NodeList nodes) {
        switch (nodes.getLength()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(nodeKlass.cast(nodes.item(0)));
            }
        }
        throw new AssertionError((Object)("Validation Leak! {" + nodes + "}"));
    }
}

