/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.util.ManagedServiceLoader;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.terracotta.connection.entity.Entity;
import org.terracotta.entity.EntityClientService;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;

public class EntityClientServiceFactory {
    private final ManagedServiceLoader loader;
    private final Map<ClassLoader, Collection<Class<? extends EntityClientService>>> cachedEntities = new WeakHashMap<ClassLoader, Collection<Class<? extends EntityClientService>>>();

    public EntityClientServiceFactory() {
        this.loader = new ManagedServiceLoader();
    }

    public <T extends Entity, C, U> EntityClientService<T, C, ? extends EntityMessage, ? extends EntityResponse, U> creationServiceForType(Class<T> cls) {
        EntityClientService foundService = null;
        Collection<Class<? extends EntityClientService>> implementations = this.getEntityServices(cls.getClassLoader());
        for (Class<? extends EntityClientService> ctype : implementations) {
            EntityClientService instance = EntityClientServiceFactory.instantiate(ctype);
            if (!instance.handlesEntityType(cls)) continue;
            foundService = instance;
            break;
        }
        return foundService;
    }

    private synchronized Collection<Class<? extends EntityClientService>> getEntityServices(ClassLoader cl) {
        Collection<Class<? extends EntityClientService>> list = this.cachedEntities.get(cl);
        if (list == null) {
            list = this.loader.getImplementationsTypes(EntityClientService.class, cl);
            this.cachedEntities.put(cl, list);
        }
        return list;
    }

    private static EntityClientService instantiate(Class<? extends EntityClientService> entry) {
        try {
            return entry.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }
}

