/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCNetworkMessageImpl;
import com.tc.net.protocol.tcm.TCActionNetworkMessage;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import java.util.Optional;

public class WireProtocolMessageImpl
extends TCNetworkMessageImpl
implements WireProtocolMessage {
    private final TCConnection sourceConnection;
    private final Optional<TCActionNetworkMessage> message;

    public static WireProtocolMessage wrapMessage(TCActionNetworkMessage msgPayload, TCConnection source) {
        WireProtocolHeader header = new WireProtocolHeader();
        header.setProtocol(WireProtocolHeader.getProtocolForMessageClass(msgPayload));
        WireProtocolMessageImpl rv = new WireProtocolMessageImpl(source, (TCNetworkHeader)header, msgPayload);
        return rv;
    }

    protected WireProtocolMessageImpl(TCConnection source, TCNetworkHeader header, TCByteBuffer[] data) {
        super(header, data);
        this.sourceConnection = source;
        this.message = Optional.empty();
    }

    protected WireProtocolMessageImpl(TCConnection source, TCNetworkHeader header, TCActionNetworkMessage msg) {
        super(header);
        this.sourceConnection = source;
        this.message = Optional.of(msg);
    }

    @Override
    public boolean prepareToSend() {
        if (!this.message.isPresent()) {
            this.getWireProtocolHeader().finalizeHeader(this.getTotalLength());
            return true;
        }
        if (this.message.get().commit()) {
            this.setPayload(this.message.get().getEntireMessageData());
            this.getWireProtocolHeader().finalizeHeader(this.getTotalLength());
            return true;
        }
        return false;
    }

    @Override
    public short getMessageProtocol() {
        return ((WireProtocolHeader)this.getHeader()).getProtocol();
    }

    @Override
    public WireProtocolHeader getWireProtocolHeader() {
        return (WireProtocolHeader)this.getHeader();
    }

    @Override
    public TCConnection getSource() {
        return this.sourceConnection;
    }

    @Override
    public void complete() {
        this.message.ifPresent(TCNetworkMessage::complete);
        super.complete();
    }

    @Override
    public boolean isValid() {
        return this.message.map(TCActionNetworkMessage::isCancelled).orElse(Boolean.FALSE) == false;
    }
}

