/*
 * Decompiled with CFR 0.152.
 */
package com.tc.runtime;

import com.tc.properties.TCPropertiesImpl;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcMonitor {
    private static final Logger logger = LoggerFactory.getLogger(GcMonitor.class);
    private final Queue<GcStats> gcStatsQueue = new ConcurrentLinkedQueue<GcStats>();
    private final Timer timer = new Timer("GcMonitor-timer", true);
    private final NotificationListener listener = (notification, handback) -> {
        if (notification.getType().equals("com.sun.management.gc.notification")) {
            CompositeData userData = (CompositeData)notification.getUserData();
            CompositeData gcInfo = (CompositeData)userData.get("gcInfo");
            GcStats gcStats = new GcStats((Long)gcInfo.get("duration"), (String)userData.get("gcAction"), (Long)gcInfo.get("startTime"), (String)userData.get("gcCause"), (String)userData.get("gcName"));
            this.gcStatsQueue.add(gcStats);
        }
    };

    public void init() {
        long delay = TCPropertiesImpl.getProperties().getLong("tc.gc.monitor.delay");
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            emitter.addNotificationListener(this.listener, null, null);
        }
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                GcMonitor.this.dump();
            }
        }, delay, delay);
    }

    public void close() {
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcMxBean);
            try {
                emitter.removeNotificationListener(this.listener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {}
        }
        this.timer.cancel();
    }

    private void dump() {
        GcStats gcStats;
        while ((gcStats = this.gcStatsQueue.poll()) != null) {
            logger.info("GC event : startTime={} / duration={} / action={} / cause={} / name={}", new Object[]{gcStats.startTimestamp, gcStats.duration, gcStats.action, gcStats.cause, gcStats.name});
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
        logger.info("Heap usage : init={} / used={} / committed={} / max={}", new Object[]{heapUsage.getInit(), heapUsage.getUsed(), heapUsage.getCommitted(), heapUsage.getMax()});
    }

    private static class GcStats {
        private final long startTimestamp;
        private final long duration;
        private final String action;
        private final String cause;
        private final String name;

        private GcStats(long duration, String action, long startTimestamp, String cause, String name) {
            this.duration = duration;
            this.action = action;
            this.startTimestamp = startTimestamp;
            this.cause = cause;
            this.name = name;
        }
    }
}

