/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity.map.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.terracotta.entity.map.common.ClearOperation;
import org.terracotta.entity.map.common.ConditionalRemoveOperation;
import org.terracotta.entity.map.common.ConditionalReplaceOperation;
import org.terracotta.entity.map.common.ContainsKeyOperation;
import org.terracotta.entity.map.common.ContainsValueOperation;
import org.terracotta.entity.map.common.EntrySetOperation;
import org.terracotta.entity.map.common.GetOperation;
import org.terracotta.entity.map.common.KeySetOperation;
import org.terracotta.entity.map.common.MapOperation;
import org.terracotta.entity.map.common.PutAllOperation;
import org.terracotta.entity.map.common.PutIfAbsentOperation;
import org.terracotta.entity.map.common.PutIfPresentOperation;
import org.terracotta.entity.map.common.PutOperation;
import org.terracotta.entity.map.common.RemoveOperation;
import org.terracotta.entity.map.common.SizeOperation;
import org.terracotta.entity.map.common.ValuesOperation;

class OperationCodec {
    OperationCodec() {
    }

    public static MapOperation decode(byte[] bytes) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(bytes));
        byte type = input.readByte();
        switch (MapOperation.Type.values()[type]) {
            case PUT: {
                return PutOperation.readFrom(input);
            }
            case GET: {
                return GetOperation.readFrom(input);
            }
            case REMOVE: {
                return RemoveOperation.readFrom(input);
            }
            case SIZE: {
                return SizeOperation.readFrom(input);
            }
            case CONTAINS_KEY: {
                return ContainsKeyOperation.readFrom(input);
            }
            case CONTAINS_VALUE: {
                return ContainsValueOperation.readFrom(input);
            }
            case CLEAR: {
                return ClearOperation.readFrom(input);
            }
            case PUT_ALL: {
                return PutAllOperation.readFrom(input);
            }
            case KEY_SET: {
                return KeySetOperation.readFrom(input);
            }
            case VALUES: {
                return ValuesOperation.readFrom(input);
            }
            case ENTRY_SET: {
                return EntrySetOperation.readFrom(input);
            }
            case PUT_IF_ABSENT: {
                return PutIfAbsentOperation.readFrom(input);
            }
            case PUT_IF_PRESENT: {
                return PutIfPresentOperation.readFrom(input);
            }
            case CONDITIONAL_REMOVE: {
                return ConditionalRemoveOperation.readFrom(input);
            }
            case CONDITIONAL_REPLACE: {
                return ConditionalReplaceOperation.readFrom(input);
            }
        }
        throw new IllegalArgumentException("Unknown map operation type " + type);
    }

    public static byte[] encode(MapOperation operation) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(byteOut);
        output.writeByte(operation.operationType().ordinal());
        operation.writeTo(output);
        output.close();
        return byteOut.toByteArray();
    }
}

