/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.store.Util;

class ChainCodec {
    private static final byte NON_SEQUENCED_CHAIN = 0;
    private static final byte SEQUENCED_CHAIN = 1;
    private static final byte SEQ_NUM_OFFSET = 8;
    private static final byte ELEMENT_PAYLOAD_OFFSET = 4;

    ChainCodec() {
    }

    public byte[] encode(Chain chain) {
        ByteBuffer msg = null;
        boolean firstIteration = true;
        for (Element element : chain) {
            if (firstIteration) {
                firstIteration = false;
                ByteBuffer buffer = ByteBuffer.allocate(1);
                if (element instanceof SequencedElement) {
                    buffer.put((byte)1);
                } else {
                    buffer.put((byte)0);
                }
                buffer.flip();
                msg = ChainCodec.combine(buffer, ChainCodec.encodeElement(element));
                continue;
            }
            if (msg == null) {
                throw new IllegalArgumentException("Message cannot be null");
            }
            msg = ChainCodec.combine(msg, ChainCodec.encodeElement(element));
        }
        return msg != null ? msg.array() : new byte[]{};
    }

    public Chain decode(byte[] payload) {
        ArrayList<Element> elements;
        block4: {
            boolean isSequenced;
            elements = new ArrayList<Element>();
            if (payload.length == 0) break block4;
            ByteBuffer buffer = ByteBuffer.wrap(payload);
            boolean bl = isSequenced = buffer.get() == 1;
            if (isSequenced) {
                while (buffer.hasRemaining()) {
                    long sequence = buffer.getLong();
                    elements.add(Util.getElement(sequence, ChainCodec.getElementPayLoad(buffer)));
                }
            } else {
                while (buffer.hasRemaining()) {
                    elements.add(Util.getElement(ChainCodec.getElementPayLoad(buffer)));
                }
            }
        }
        return Util.getChain(elements);
    }

    private static ByteBuffer combine(ByteBuffer buffer1, ByteBuffer buffer2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(buffer1.remaining() + buffer2.remaining());
        byteBuffer.put(buffer1);
        byteBuffer.put(buffer2);
        byteBuffer.flip();
        return byteBuffer;
    }

    private static ByteBuffer encodeElement(Element element) {
        ByteBuffer buffer = null;
        if (element instanceof SequencedElement) {
            buffer = ByteBuffer.allocate(12 + element.getPayload().remaining());
            buffer.putLong(((SequencedElement)element).getSequenceNumber());
        } else {
            buffer = ByteBuffer.allocate(4 + element.getPayload().remaining());
        }
        buffer.putInt(element.getPayload().remaining());
        buffer.put(element.getPayload());
        buffer.flip();
        return buffer;
    }

    private static ByteBuffer getElementPayLoad(ByteBuffer buffer) {
        int payloadSize = buffer.getInt();
        buffer.limit(buffer.position() + payloadSize);
        ByteBuffer elementPayload = buffer.slice();
        buffer.position(buffer.limit());
        buffer.limit(buffer.capacity());
        return elementPayload;
    }
}

