/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;

class NoInvalidationServerStoreProxy
implements ServerStoreProxy {
    private final ServerStoreMessageFactory messageFactory;
    private final EhcacheClientEntity entity;

    NoInvalidationServerStoreProxy(ServerStoreMessageFactory messageFactory, EhcacheClientEntity entity) {
        this.messageFactory = messageFactory;
        this.entity = entity;
    }

    @Override
    public String getCacheId() {
        return this.messageFactory.getCacheId();
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Chain get(long key) {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invoke(this.messageFactory.getOperation(key), false);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getType() == EhcacheEntityResponse.Type.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for get operation was invalid : " + (response != null ? response.getType().toString() : "null message"));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) {
        try {
            this.entity.invoke(this.messageFactory.appendOperation(key, payLoad), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invoke(this.messageFactory.getAndAppendOperation(key, payLoad), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getType() == EhcacheEntityResponse.Type.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for getAndAppend operation was invalid : " + (response != null ? response.getType().toString() : "null message"));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.entity.invokeAsync(this.messageFactory.replaceAtHeadOperation(key, expect, update), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.entity.invoke(this.messageFactory.clearOperation(), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }
}

