/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.internal.EhcacheClientEntity;
import org.ehcache.clustered.client.internal.EhcacheClientEntityFactory;
import org.ehcache.clustered.client.internal.EhcacheEntityBusyException;
import org.ehcache.clustered.client.internal.EhcacheEntityCreationException;
import org.ehcache.clustered.client.internal.EhcacheEntityNotFoundException;
import org.ehcache.clustered.client.internal.EhcacheEntityValidationException;
import org.ehcache.clustered.client.internal.service.ClusteredMapRepository;
import org.ehcache.clustered.client.internal.service.ClusteredStateRepository;
import org.ehcache.clustered.client.internal.service.ClusteredTierDestructionException;
import org.ehcache.clustered.client.internal.service.ClusteredTierException;
import org.ehcache.clustered.client.internal.service.ClusteredTierReleaseException;
import org.ehcache.clustered.client.internal.service.ClusteredTierValidationException;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.internal.store.EventualServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.StrongServerStoreProxy;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.InvalidStoreException;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.entity.map.common.ConcurrentClusteredMap;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;

@ServiceDependencies(value={ClusteredStore.Provider.class})
class DefaultClusteringService
implements ClusteringService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusteringService.class);
    static final String CONNECTION_PREFIX = "Ehcache:";
    private final ClusteringServiceConfiguration configuration;
    private final URI clusterUri;
    private final String entityIdentifier;
    private final ConcurrentMap<String, Tuple<DefaultClusterCacheIdentifier, ClusteredMapRepository>> knownPersistenceSpaces = new ConcurrentHashMap();
    private Connection clusterConnection;
    private EhcacheClientEntityFactory entityFactory;
    private EhcacheClientEntity entity;
    private volatile boolean inMaintenance = false;

    DefaultClusteringService(ClusteringServiceConfiguration configuration) {
        this.configuration = configuration;
        URI ehcacheUri = configuration.getClusterUri();
        this.clusterUri = DefaultClusteringService.extractClusterUri(ehcacheUri);
        this.entityIdentifier = this.clusterUri.relativize(ehcacheUri).getPath();
    }

    private static URI extractClusterUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ClusteringServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        block9: {
            try {
                Properties properties = new Properties();
                properties.put("connection.name", CONNECTION_PREFIX + this.entityIdentifier);
                this.clusterConnection = ConnectionFactory.connect(this.clusterUri, properties);
            }
            catch (ConnectionException ex) {
                throw new RuntimeException(ex);
            }
            this.entityFactory = new EhcacheClientEntityFactory(this.clusterConnection);
            try {
                if (this.configuration.isAutoCreate()) {
                    this.entity = this.autoCreateEntity();
                    break block9;
                }
                try {
                    this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
                }
                catch (EntityNotFoundException e) {
                    throw new IllegalStateException("The clustered tier manager '" + this.entityIdentifier + "' does not exist." + " Please review your configuration.", e);
                }
            }
            catch (RuntimeException e) {
                this.entityFactory = null;
                try {
                    this.clusterConnection.close();
                    this.clusterConnection = null;
                }
                catch (IOException ex) {
                    LOGGER.warn("Error closing cluster connection: " + ex);
                }
                throw e;
            }
        }
    }

    private EhcacheClientEntity autoCreateEntity() throws EhcacheEntityValidationException, IllegalStateException {
        while (true) {
            try {
                this.entityFactory.create(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EhcacheEntityCreationException e) {
                throw new IllegalStateException("Could not create the clustered tier manager '" + this.entityIdentifier + "'.", e);
            }
            catch (EntityAlreadyExistsException e) {
            }
            catch (EhcacheEntityBusyException e) {
                // empty catch block
            }
            try {
                return this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EntityNotFoundException entityNotFoundException) {
                continue;
            }
            break;
        }
    }

    public void startForMaintenance(ServiceProvider<MaintainableService> serviceProvider) {
        try {
            this.clusterConnection = ConnectionFactory.connect(this.clusterUri, new Properties());
        }
        catch (ConnectionException ex) {
            throw new RuntimeException(ex);
        }
        this.entityFactory = new EhcacheClientEntityFactory(this.clusterConnection);
        if (!this.entityFactory.acquireLeadership(this.entityIdentifier)) {
            this.entityFactory = null;
            try {
                this.clusterConnection.close();
                this.clusterConnection = null;
            }
            catch (IOException e) {
                LOGGER.warn("Error closing cluster connection: " + e);
            }
            throw new IllegalStateException("Couldn't acquire cluster-wide maintenance lease");
        }
        this.inMaintenance = true;
    }

    public void stop() {
        LOGGER.info("stop called for clustered tiers on {}", (Object)this.clusterUri);
        this.entityFactory = null;
        this.inMaintenance = false;
        this.entity = null;
        try {
            if (this.clusterConnection != null) {
                this.clusterConnection.close();
                this.clusterConnection = null;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void destroyAll() throws CachePersistenceException {
        if (!this.inMaintenance) {
            throw new IllegalStateException("Maintenance mode required");
        }
        LOGGER.info("destroyAll called for clustered tiers on {}", (Object)this.clusterUri);
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EhcacheEntityNotFoundException e) {
            throw new CachePersistenceException("Clustered tiers on " + this.clusterUri + " not found", (Throwable)e);
        }
        catch (EhcacheEntityBusyException e) {
            throw new CachePersistenceException("Can not delete clustered tiers on " + this.clusterUri, (Throwable)e);
        }
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return Arrays.asList(ClusteredResourceType.Types.values()).contains(resourceType);
    }

    public PersistableResourceService.PersistenceSpaceIdentifier getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) throws CachePersistenceException {
        DefaultClusterCacheIdentifier identifier = new DefaultClusterCacheIdentifier(name);
        Tuple<DefaultClusterCacheIdentifier, ClusteredMapRepository> existing = this.knownPersistenceSpaces.putIfAbsent(name, new Tuple<DefaultClusterCacheIdentifier, ClusteredMapRepository>(identifier, new ClusteredMapRepository()));
        if (existing != null) {
            identifier = (DefaultClusterCacheIdentifier)existing.first;
        }
        return identifier;
    }

    private ConcurrentHashMap<EntityRef<ConcurrentClusteredMap, Object>, ConcurrentClusteredMap<?, ?>> getNewMapEntityMap() {
        return new ConcurrentHashMap();
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        if (!this.isKnownIdentifier(identifier)) {
            throw new CachePersistenceException("Unknown identifier: " + identifier);
        }
        DefaultClusterCacheIdentifier clusterCacheIdentifier = (DefaultClusterCacheIdentifier)identifier;
        Tuple tuple = (Tuple)this.knownPersistenceSpaces.remove(clusterCacheIdentifier.getId());
        ((ClusteredMapRepository)tuple.second).clear();
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        if (!this.isKnownIdentifier(identifier)) {
            throw new CachePersistenceException("Unknown identifier: " + identifier);
        }
        DefaultClusterCacheIdentifier clusterCacheIdentifier = (DefaultClusterCacheIdentifier)identifier;
        return new ClusteredStateRepository(clusterCacheIdentifier, name, this);
    }

    public void destroy(String name) throws CachePersistenceException {
        try {
            this.entity.destroyCache(name);
        }
        catch (ClusteredTierDestructionException e) {
            throw new CachePersistenceException("Cannot destroy clustered tier '" + name + "' on " + this.clusterUri, (Throwable)e);
        }
    }

    @Override
    public <K, V> ServerStoreProxy getServerStoreProxy(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<K, V> storeConfig, Consistency configuredConsistency) throws CachePersistenceException {
        String cacheId;
        block15: {
            if (!this.isKnownIdentifier(cacheIdentifier)) {
                throw new CachePersistenceException("Unknown identifier: " + cacheIdentifier);
            }
            cacheId = cacheIdentifier.getId();
            if (configuredConsistency == null) {
                throw new NullPointerException("Consistency cannot be null");
            }
            ClusteredResourcePool clusteredResourcePool = null;
            for (ClusteredResourceType<? extends ClusteredResourcePool> type : ClusteredResourceType.Types.values()) {
                ClusteredResourcePool pool = (ClusteredResourcePool)storeConfig.getResourcePools().getPoolForResource(type);
                if (pool == null) continue;
                if (clusteredResourcePool != null) {
                    throw new IllegalStateException("At most one clustered resource supported for a cache");
                }
                clusteredResourcePool = pool;
            }
            if (clusteredResourcePool == null) {
                throw new IllegalStateException("A clustered resource is required for a clustered cache");
            }
            ServerStoreConfiguration clientStoreConfiguration = new ServerStoreConfiguration(clusteredResourcePool.getPoolAllocation(), storeConfig.getKeyType().getName(), storeConfig.getValueType().getName(), null, null, storeConfig.getKeySerializer() == null ? null : storeConfig.getKeySerializer().getClass().getName(), storeConfig.getValueSerializer() == null ? null : storeConfig.getValueSerializer().getClass().getName(), configuredConsistency);
            try {
                if (this.configuration.isAutoCreate()) {
                    try {
                        this.entity.validateCache(cacheId, clientStoreConfiguration);
                        break block15;
                    }
                    catch (ClusteredTierValidationException ex) {
                        if (ex.getCause() instanceof InvalidStoreException) {
                            this.entity.createCache(cacheId, clientStoreConfiguration);
                            break block15;
                        }
                        throw ex;
                    }
                }
                this.entity.validateCache(cacheId, clientStoreConfiguration);
            }
            catch (ClusteredTierException e) {
                throw new CachePersistenceException("Unable to create clustered tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "'", (Throwable)e);
            }
        }
        ServerStoreMessageFactory messageFactory = new ServerStoreMessageFactory(cacheId);
        switch (configuredConsistency) {
            case STRONG: {
                return new StrongServerStoreProxy(messageFactory, this.entity);
            }
            case EVENTUAL: {
                return new EventualServerStoreProxy(messageFactory, this.entity);
            }
        }
        throw new AssertionError((Object)("Unknown consistency : " + (Object)((Object)configuredConsistency)));
    }

    @Override
    public void releaseServerStoreProxy(ServerStoreProxy storeProxy) {
        String cacheId = storeProxy.getCacheId();
        try {
            this.entity.releaseCache(cacheId);
        }
        catch (ClusteredTierReleaseException e) {
            throw new IllegalStateException(e);
        }
    }

    <K extends Serializable, V extends Serializable> ConcurrentMap<K, V> getConcurrentMap(ClusteringService.ClusteredCacheIdentifier identifier, String name, Class<K> keyClass, Class<V> valueClass) {
        ConcurrentClusteredMap map;
        Tuple tuple = (Tuple)this.knownPersistenceSpaces.get(identifier.getId());
        if (tuple == null) {
            throw new AssertionError((Object)("Lost a space?? " + identifier));
        }
        ClusteredMapRepository mapRepository = (ClusteredMapRepository)tuple.second;
        while ((map = mapRepository.getMap(name)) == null) {
            mapRepository.addNewMap(name, this.createConcurrentClusteredMap(name, keyClass, valueClass));
        }
        return map;
    }

    private ConcurrentClusteredMap createConcurrentClusteredMap(String name, Class<?> keyClass, Class<?> valueClass) {
        try {
            ConcurrentClusteredMap clusteredMap;
            EntityRef clusteredMapRef = this.clusterConnection.getEntityRef(ConcurrentClusteredMap.class, 1L, name);
            try {
                clusteredMap = clusteredMapRef.fetchEntity();
            }
            catch (EntityNotFoundException e) {
                clusteredMapRef.create(null);
                clusteredMap = clusteredMapRef.fetchEntity();
            }
            clusteredMap.setTypes(keyClass, valueClass);
            return clusteredMap;
        }
        catch (EntityNotFoundException e) {
            throw new AssertionError((Object)"Should not happen");
        }
        catch (EntityException e) {
            LOGGER.error("Classpath issue - missing entity provider", (Throwable)e);
            throw new AssertionError((Object)"Classpath issues as expected entity is not resolvable");
        }
    }

    private boolean isKnownIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) {
        for (Tuple tuple : this.knownPersistenceSpaces.values()) {
            if (!((DefaultClusterCacheIdentifier)tuple.first).equals(identifier)) continue;
            return true;
        }
        return false;
    }

    static class Tuple<K, V> {
        final K first;
        final V second;

        Tuple(K first, V second) {
            this.first = first;
            this.second = second;
        }
    }

    private static class DefaultClusterCacheIdentifier
    implements ClusteringService.ClusteredCacheIdentifier {
        private final String id;

        private DefaultClusterCacheIdentifier(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Class<ClusteringService> getServiceType() {
            return ClusteringService.class;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.id;
        }
    }
}

