/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.lock;

import java.io.Closeable;
import org.ehcache.clustered.client.internal.lock.VoltronReadWriteLockClient;
import org.ehcache.clustered.common.internal.lock.LockMessaging;
import org.terracotta.connection.Connection;
import org.terracotta.connection.entity.EntityRef;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityVersionMismatchException;

public class VoltronReadWriteLock {
    private final EntityRef<VoltronReadWriteLockClient, Void> reference;

    public VoltronReadWriteLock(Connection connection, String id) {
        try {
            this.reference = VoltronReadWriteLock.createEntityRef(connection, id);
        }
        catch (EntityNotProvidedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Hold readLock() {
        return this.lock(LockMessaging.HoldType.READ);
    }

    public Hold writeLock() {
        return this.lock(LockMessaging.HoldType.WRITE);
    }

    public Hold tryReadLock() {
        return this.tryLock(LockMessaging.HoldType.READ);
    }

    public Hold tryWriteLock() {
        return this.tryLock(LockMessaging.HoldType.WRITE);
    }

    private Hold lock(LockMessaging.HoldType type) {
        VoltronReadWriteLockClient client = this.createClientEntity();
        client.lock(type);
        return new HoldImpl(client, type);
    }

    private Hold tryLock(LockMessaging.HoldType type) {
        VoltronReadWriteLockClient client = this.createClientEntity();
        if (client.tryLock(type)) {
            return new HoldImpl(client, type);
        }
        client.close();
        this.tryDestroy();
        return null;
    }

    private boolean tryDestroy() {
        try {
            return this.reference.tryDestroy();
        }
        catch (EntityNotProvidedException e) {
            throw new AssertionError((Object)e);
        }
        catch (EntityNotFoundException e) {
            return false;
        }
    }

    private VoltronReadWriteLockClient createClientEntity() {
        try {
            while (true) {
                try {
                    this.reference.create(null);
                }
                catch (EntityAlreadyExistsException f) {
                    // empty catch block
                }
                try {
                    return this.reference.fetchEntity();
                }
                catch (EntityNotFoundException e) {
                    continue;
                }
                break;
            }
        }
        catch (EntityVersionMismatchException e) {
            throw new IllegalStateException(e);
        }
        catch (EntityNotProvidedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static EntityRef<VoltronReadWriteLockClient, Void> createEntityRef(Connection connection, String identifier) throws EntityNotProvidedException {
        return connection.getEntityRef(VoltronReadWriteLockClient.class, 1L, "VoltronReadWriteLock-" + identifier);
    }

    private class HoldImpl
    implements Hold {
        private final VoltronReadWriteLockClient client;
        private final LockMessaging.HoldType type;

        public HoldImpl(VoltronReadWriteLockClient client, LockMessaging.HoldType type) {
            this.client = client;
            this.type = type;
        }

        @Override
        public void close() {
            this.unlock();
        }

        @Override
        public void unlock() {
            this.client.unlock(this.type);
            this.client.close();
            VoltronReadWriteLock.this.tryDestroy();
        }
    }

    public static interface Hold
    extends Closeable {
        @Override
        public void close();

        public void unlock();
    }
}

