/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config.builders;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.Builder;
import org.ehcache.config.units.MemoryUnit;

public class ServerSideConfigurationBuilder
implements Builder<ClusteringServiceConfiguration> {
    private final URI clusterUri;
    private final boolean autoCreate;
    private final String defaultServerResource;
    private final Map<String, ServerSideConfiguration.Pool> pools;

    ServerSideConfigurationBuilder(URI clusterUri, boolean autoCreate) {
        this.clusterUri = clusterUri;
        this.autoCreate = autoCreate;
        this.defaultServerResource = null;
        this.pools = Collections.emptyMap();
    }

    private ServerSideConfigurationBuilder(ServerSideConfigurationBuilder original, String defaultServerResource) {
        this.clusterUri = original.clusterUri;
        this.autoCreate = original.autoCreate;
        this.pools = original.pools;
        this.defaultServerResource = defaultServerResource;
    }

    private ServerSideConfigurationBuilder(ServerSideConfigurationBuilder original, String poolName, ServerSideConfiguration.Pool poolDefinition) {
        this.clusterUri = original.clusterUri;
        this.autoCreate = original.autoCreate;
        this.defaultServerResource = original.defaultServerResource;
        HashMap<String, ServerSideConfiguration.Pool> pools = new HashMap<String, ServerSideConfiguration.Pool>(original.pools);
        if (pools.put(poolName, poolDefinition) != null) {
            throw new IllegalArgumentException("Pool '" + poolName + "' already defined");
        }
        this.pools = Collections.unmodifiableMap(pools);
    }

    public ServerSideConfigurationBuilder defaultServerResource(String defaultServerResource) {
        return new ServerSideConfigurationBuilder(this, defaultServerResource);
    }

    public ServerSideConfigurationBuilder resourcePool(String name, long size, MemoryUnit unit, String serverResource) {
        return this.resourcePool(name, new ServerSideConfiguration.Pool(unit.toBytes(size), serverResource));
    }

    public ServerSideConfigurationBuilder resourcePool(String name, long size, MemoryUnit unit) {
        return this.resourcePool(name, new ServerSideConfiguration.Pool(unit.toBytes(size)));
    }

    public ServerSideConfigurationBuilder resourcePool(String name, ServerSideConfiguration.Pool definition) {
        return new ServerSideConfigurationBuilder(this, name, definition);
    }

    public ClusteringServiceConfiguration build() {
        return new ClusteringServiceConfiguration(this.clusterUri, this.autoCreate, this.buildServerSideConfiguration());
    }

    private ServerSideConfiguration buildServerSideConfiguration() {
        if (this.defaultServerResource == null) {
            return new ServerSideConfiguration(this.pools);
        }
        return new ServerSideConfiguration(this.defaultServerResource, this.pools);
    }
}

