/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.io.TCFile;
import com.tc.io.TCFileChannel;
import com.tc.io.TCFileLock;
import com.tc.io.TCRandomFileAccess;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.util.Assert;
import com.tc.util.BlockingStartupLock;
import com.tc.util.StartupLock;
import com.tc.util.TCAssertionError;
import com.tc.util.TCDataFileLockingException;
import com.tc.util.startuplock.FileNotCreatedException;
import com.tc.util.startuplock.LocationNotCreatedException;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class AbstractStartupLock
implements StartupLock {
    private static final TCLogger logger = TCLogging.getLogger(BlockingStartupLock.class);
    private final TCFile location;
    protected TCFileLock lock;
    protected TCFileChannel channel;
    protected boolean isBlocked;
    private final boolean retry;

    public AbstractStartupLock(TCFile location, boolean retries) {
        this.location = location;
        this.retry = retries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() {
        try {
            if (this.lock != null) {
                try {
                    this.lock.release();
                    this.isBlocked = false;
                }
                catch (IOException e) {
                    logger.error(e);
                }
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    logger.error(e);
                }
            }
        }
        finally {
            this.lock = null;
            this.channel = null;
        }
    }

    @Override
    public synchronized boolean canProceed(TCRandomFileAccess randomFileAccess) throws LocationNotCreatedException, FileNotCreatedException {
        TCFile tcFile = this.location.createNewTCFile(this.location, "startup.lck");
        this.ensureLocationExists();
        this.ensureFileExists(tcFile);
        try {
            this.channel = randomFileAccess.getChannel(tcFile, "rw");
        }
        catch (FileNotFoundException fnfe) {
            throw new TCAssertionError(fnfe);
        }
        while (true) {
            try {
                this.requestLock(tcFile);
            }
            catch (TCDataFileLockingException tdfle) {
                if (!this.retry) {
                    throw tdfle;
                }
                logger.error(tdfle.getMessage() + ". Retrying");
                continue;
            }
            break;
        }
        return this.lock != null;
    }

    protected abstract void requestLock(TCFile var1);

    private void ensureFileExists(TCFile file) throws FileNotCreatedException {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new FileNotCreatedException("Could not create file for startup lock: " + file + ". Please ensure that this file can be created.");
            }
            Assert.eval(file.exists());
        }
    }

    private void ensureLocationExists() throws LocationNotCreatedException {
        if (!this.location.exists()) {
            try {
                this.location.forceMkdir();
            }
            catch (IOException e) {
                throw new LocationNotCreatedException("Could not create location for startup lock: " + this.location + ". Please ensure that this directory can be created. " + e.getMessage());
            }
        }
    }
}

