/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.object.ClientIDProvider;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockFlushCallback;
import com.tc.object.locks.LockID;
import com.tc.object.locks.RecallBatchContext;
import com.tc.object.locks.RemoteLockManager;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.LockRequestMessage;
import com.tc.object.msg.LockRequestMessageFactory;
import com.tc.util.concurrent.TaskRunner;
import com.tc.util.concurrent.Timer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RemoteLockManagerImpl
implements RemoteLockManager {
    private static final TCLogger logger = TCLogging.getLogger(RemoteLockManagerImpl.class);
    private static final int MAX_BATCHED_RECALL_COMMITS = 10000;
    private static final long MAX_TIME_IN_QUEUE = 1L;
    private final LockRequestMessageFactory messageFactory;
    private final ClientIDProvider clientIdProvider;
    private final Queue<RecallBatchContext> queue = new LinkedList<RecallBatchContext>();
    private boolean shutdown;
    private final Timer batchRecallTimer;
    private ScheduledFuture<?> batchRecallTask;

    public RemoteLockManagerImpl(ClientIDProvider clientIdProvider, LockRequestMessageFactory messageFactory, TaskRunner taskRunner) {
        this.messageFactory = messageFactory;
        this.clientIdProvider = clientIdProvider;
        this.batchRecallTimer = taskRunner.newTimer("Batch Recall Timer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Queue<RecallBatchContext> queue = this.queue;
        synchronized (queue) {
            this.queue.clear();
        }
    }

    @Override
    public ClientID getClientID() {
        return this.clientIdProvider.getClientID();
    }

    @Override
    public void flush(LockID lock) {
    }

    @Override
    public boolean asyncFlush(LockID lock, LockFlushCallback callback) {
        callback.transactionsForLockFlushed(lock);
        return true;
    }

    @Override
    public void interrupt(LockID lock, ThreadID thread) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeInterruptWait(lock, thread);
        this.sendMessage(msg);
    }

    @Override
    public void lock(LockID lock, ThreadID thread, ServerLockLevel level) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeLock(lock, thread, level);
        this.sendMessage(msg);
    }

    @Override
    public void query(LockID lock, ThreadID thread) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeQuery(lock, thread);
        this.sendMessage(msg);
    }

    @Override
    public void tryLock(LockID lock, ThreadID thread, ServerLockLevel level, long timeout) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeTryLock(lock, thread, timeout, level);
        this.sendMessage(msg);
    }

    @Override
    public void unlock(LockID lock, ThreadID thread, ServerLockLevel level) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeUnlock(lock, thread, level);
        this.sendMessage(msg);
    }

    @Override
    public void wait(LockID lock, ThreadID thread, long waitTime) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeWait(lock, thread, waitTime);
        this.sendMessage(msg);
    }

    private void recallCommit(LockID lock, Collection<ClientServerExchangeLockContext> lockState) {
        this.sendPendingRecallCommits();
        LockRequestMessage msg = this.createMessage();
        msg.initializeRecallCommit(lock);
        for (ClientServerExchangeLockContext context : lockState) {
            msg.addContext(context);
        }
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recallCommit(LockID lock, Collection<ClientServerExchangeLockContext> lockState, boolean batch) {
        if (!batch) {
            this.recallCommit(lock, lockState);
            return;
        }
        Queue<RecallBatchContext> queue = this.queue;
        synchronized (queue) {
            this.queue.add(new RecallBatchContext(lockState, lock));
            if (this.queue.size() >= 10000) {
                this.sendPendingRecallCommits();
                return;
            }
            if (this.batchRecallTask == null && !this.shutdown) {
                this.batchRecallTask = this.batchRecallTimer.schedule(new BatchRecallCommitsTask(), 1L, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Queue<RecallBatchContext> queue = this.queue;
        synchronized (queue) {
            this.shutdown = true;
            this.cancelTimerTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        Queue<RecallBatchContext> queue = this.queue;
        synchronized (queue) {
            return this.shutdown;
        }
    }

    private void cancelTimerTask() {
        if (this.batchRecallTask != null) {
            this.batchRecallTask.cancel(false);
        }
        this.batchRecallTask = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPendingRecallCommits() {
        Queue<RecallBatchContext> queue = this.queue;
        synchronized (queue) {
            this.sendBatchedRequestsImmediately();
            this.cancelTimerTask();
        }
    }

    private void sendBatchedRequestsImmediately() {
        if (this.queue.size() == 0) {
            return;
        }
        LockRequestMessage lrm = this.createMessage();
        lrm.initializeBatchedRecallCommit();
        for (RecallBatchContext context : this.queue) {
            lrm.addRecallBatchContext(context);
        }
        this.queue.clear();
        this.sendMessage(lrm);
    }

    private LockRequestMessage createMessage() {
        return this.messageFactory.newLockRequestMessage();
    }

    protected void sendMessage(LockRequestMessage msg) {
        msg.send();
    }

    private class BatchRecallCommitsTask
    implements Runnable {
        private BatchRecallCommitsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Queue queue = RemoteLockManagerImpl.this.queue;
            synchronized (queue) {
                if (RemoteLockManagerImpl.this.shutdown) {
                    logger.info("Ignoring Batched Recall Requests Timer task as timer is already shut down.");
                    return;
                }
                RemoteLockManagerImpl.this.sendBatchedRequestsImmediately();
                RemoteLockManagerImpl.this.batchRecallTask = null;
            }
        }
    }
}

