/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.net.protocol.AbstractTCNetworkMessage;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageHeaderImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnknownNameException;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.util.AbstractIdentifier;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.io.IOException;

public abstract class TCMessageImpl
extends AbstractTCNetworkMessage
implements TCMessage {
    private final MessageMonitor monitor;
    private final SetOnceFlag processed = new SetOnceFlag();
    private final SetOnceFlag isSent = new SetOnceFlag();
    private final TCMessageType type;
    private final MessageChannel channel;
    private final boolean isOutgoing;
    private int nvCount;
    private TCByteBufferOutputStream out;
    private TCByteBufferInputStream bbis;
    private int messageVersion;

    protected TCMessageImpl(MessageMonitor monitor, TCByteBufferOutputStream output, MessageChannel channel, TCMessageType type) {
        super((TCNetworkHeader)new TCMessageHeaderImpl(type), false);
        this.monitor = monitor;
        this.type = type;
        this.channel = channel;
        this.out = output;
        this.out.writeInt(0);
        this.isOutgoing = true;
    }

    protected TCMessageImpl(MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super((TCNetworkHeader)header, data);
        this.monitor = monitor;
        this.type = TCMessageType.getInstance(header.getMessageType());
        this.messageVersion = header.getMessageTypeVersion();
        this.bbis = new TCByteBufferInputStream(data);
        this.channel = channel;
        this.isOutgoing = false;
    }

    @Override
    public TCMessageType getMessageType() {
        return this.type;
    }

    protected int getMessageVersion() {
        return this.messageVersion;
    }

    protected void setMessageVersion(int version) {
        this.messageVersion = version;
    }

    protected TCByteBufferInputStream getInputStream() {
        return this.bbis;
    }

    protected TCByteBufferOutputStream getOutputStream() {
        return this.out;
    }

    protected void dehydrateValues() {
    }

    @Override
    public void dehydrate() {
        this.dehydrate(null);
    }

    private void dehydrate(TCByteBuffer[] nvData) {
        if (this.processed.attemptSet()) {
            try {
                if (nvData == null) {
                    nvData = this.nvToTCByteBufferArray();
                }
                this.setPayload(nvData);
                this.populateHeader();
                this.seal();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException(t);
            }
            finally {
                this.out.close();
                if (!this.isOutputStreamRecycled()) {
                    this.out = null;
                }
            }
        }
    }

    private final TCByteBuffer[] nvToTCByteBufferArray() {
        this.dehydrateValues();
        TCByteBuffer[] nvData = this.out.toArray();
        Assert.eval(nvData.length > 0);
        nvData[0].putInt(0, this.nvCount);
        return nvData;
    }

    private void populateHeader() {
        TCMessageHeader hdr = (TCMessageHeader)this.getHeader();
        hdr.setMessageType(this.getMessageType().getType());
        hdr.setMessageTypeVersion(this.getMessageVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void hydrate() throws IOException, UnknownNameException {
        if (this.processed.attemptSet()) {
            try {
                int count = this.bbis.readInt();
                if (count < 0) {
                    throw new IOException("negative NV count: " + count);
                }
                for (int i = 0; i < count; ++i) {
                    byte name = this.bbis.readByte();
                    if (this.hydrateValue(name)) continue;
                    logger.error(" Hydrate Error - " + this.toString());
                    throw new UnknownNameException(this.getClass(), name);
                }
            }
            finally {
                this.bbis.close();
                this.bbis = null;
                this.doRecycleOnRead();
            }
            this.monitor.newIncomingMessage(this);
        }
    }

    public void doRecycleOnRead() {
        this.recycle();
    }

    protected boolean isOutputStreamRecycled() {
        return false;
    }

    protected void recycleOutputStream() {
        if (this.out != null) {
            this.out.recycle();
        }
    }

    protected abstract boolean hydrateValue(byte var1) throws IOException;

    protected boolean getBooleanValue() throws IOException {
        return this.bbis.readBoolean();
    }

    protected byte getByteValue() throws IOException {
        return this.bbis.readByte();
    }

    protected char getCharValue() throws IOException {
        return this.bbis.readChar();
    }

    protected double getDoubleValue() throws IOException {
        return this.bbis.readDouble();
    }

    protected float getFloatValue() throws IOException {
        return this.bbis.readFloat();
    }

    protected int getIntValue() throws IOException {
        return this.bbis.readInt();
    }

    protected long getLongValue() throws IOException {
        return this.bbis.readLong();
    }

    protected short getShortValue() throws IOException {
        return this.bbis.readShort();
    }

    protected NodeID getNodeIDValue() throws IOException {
        return this.getObject(new NodeIDSerializer()).getNodeID();
    }

    protected LockID getLockIDValue() throws IOException {
        return this.getObject(new LockIDSerializer()).getLockID();
    }

    protected <T extends TCSerializable<T>> T getObject(T target) throws IOException {
        return (T)((TCSerializable)target.deserializeFrom(this.bbis));
    }

    protected String getStringValue() throws IOException {
        return this.bbis.readString();
    }

    protected byte[] getBytesArray() throws IOException {
        int length = this.bbis.readInt();
        byte[] bytes = new byte[length];
        int off = 0;
        while (length > 0) {
            int read = this.bbis.read(bytes, off, length);
            length -= read;
            off += read;
        }
        return bytes;
    }

    protected void putNVPair(byte name, boolean value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeBoolean(value);
    }

    protected void putNVPair(byte name, byte value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeByte(value);
    }

    protected void putNVPair(byte name, char value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeChar(value);
    }

    protected void putNVPair(byte name, double value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeDouble(value);
    }

    protected void putNVPair(byte name, float value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeFloat(value);
    }

    protected void putNVPair(byte name, int value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeInt(value);
    }

    protected void putNVPair(byte name, long value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeLong(value);
    }

    protected void putNVPair(byte name, short value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeShort(value);
    }

    protected void putNVPair(byte name, String value) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeString(value);
    }

    protected void putNVPair(byte name, NodeID nodeID) {
        ++this.nvCount;
        this.out.write(name);
        new NodeIDSerializer(nodeID).serializeTo(this.out);
    }

    protected void putNVPair(byte name, LockID lid) {
        ++this.nvCount;
        this.out.write(name);
        new LockIDSerializer(lid).serializeTo(this.out);
    }

    protected void putNVPair(byte name, TCSerializable<?> object) {
        ++this.nvCount;
        this.out.write(name);
        object.serializeTo(this.out);
    }

    protected void putNVPair(byte name, TCByteBuffer[] data) {
        ++this.nvCount;
        this.out.write(name);
        this.out.write(data);
    }

    protected void putNVPair(byte name, byte[] bytes) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    protected void putNVPair(byte name, AbstractIdentifier identifier) {
        ++this.nvCount;
        this.out.write(name);
        this.out.writeLong(identifier.toLong());
    }

    public ChannelID getChannelID() {
        return this.channel.getChannelID();
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public void send() {
        if (this.isSent.attemptSet()) {
            this.dehydrate();
            this.basicSend();
        }
    }

    private void basicSend() {
        this.channel.send(this);
        this.monitor.newOutgoingMessage(this);
    }

    public void cloneAndSend(TCMessageImpl message) {
        if (this.isSent.attemptSet()) {
            this.dehydrate(message.getPayload());
            this.basicSend();
        }
    }

    @Override
    public NodeID getSourceNodeID() {
        return this.isOutgoing ? this.channel.getLocalNodeID() : this.channel.getRemoteNodeID();
    }

    @Override
    public NodeID getDestinationNodeID() {
        return this.isOutgoing ? this.channel.getRemoteNodeID() : this.channel.getLocalNodeID();
    }
}

