/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.ecore2xtext;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.wizard.EPackageInfo;
import org.eclipse.xtext.xtext.wizard.Ecore2XtextConfiguration;
import org.eclipse.xtext.xtext.wizard.ecore2xtext.UniqueNameUtil;

public class Ecore2XtextExtensions {
    public static Iterable<EClassifier> allConcreteRuleClassifiers(Ecore2XtextConfiguration it) {
        boolean _tripleEquals;
        Iterable _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean bl = _tripleEquals = _rootElementClass == null;
        if (_tripleEquals) {
            Set<EPackageInfo> _ePackageInfos = it.getEPackageInfos();
            Functions.Function1 _function = it_1 -> {
                EPackage _ePackage = it_1.getEPackage();
                return Ecore2XtextExtensions.allReferencedClassifiers(_ePackage, false);
            };
            Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Set _set = IterableExtensions.toSet((Iterable)_flatten);
            Functions.Function1 _function_1 = it_1 -> Ecore2XtextExtensions.needsConcreteRule(it_1);
            _xifexpression = IterableExtensions.filter((Iterable)_set, (Functions.Function1)_function_1);
        } else {
            Set _xblockexpression = null;
            EClass _rootElementClass_1 = it.getRootElementClass();
            EClassifier _cast = (EClassifier)EClassifier.class.cast(_rootElementClass_1);
            ArrayList c = CollectionLiterals.newArrayList((Object[])new EClassifier[]{_cast});
            EClass _rootElementClass_2 = it.getRootElementClass();
            Ecore2XtextExtensions.allAssignedClassifiers(_rootElementClass_2, c);
            Functions.Function1 _function_2 = cl -> Ecore2XtextExtensions.needsConcreteRule(cl);
            Iterable _filter = IterableExtensions.filter((Iterable)c, (Functions.Function1)_function_2);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            _xifexpression = _xblockexpression;
        }
        return _xifexpression;
    }

    public static Collection<EClass> allDispatcherRuleClasses(Ecore2XtextConfiguration it) {
        boolean _tripleEquals;
        Set _xifexpression = null;
        EClass _rootElementClass = it.getRootElementClass();
        boolean bl = _tripleEquals = _rootElementClass == null;
        if (_tripleEquals) {
            Set<EPackageInfo> _ePackageInfos = it.getEPackageInfos();
            Functions.Function1 _function = it_1 -> {
                EPackage _ePackage = it_1.getEPackage();
                return Ecore2XtextExtensions.allReferencedClassifiers(_ePackage, false);
            };
            Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Set _set = IterableExtensions.toSet((Iterable)_flatten);
            Functions.Function1 _function_1 = c -> Ecore2XtextExtensions.needsDispatcherRule(c);
            Iterable _filter = IterableExtensions.filter((Iterable)_set, (Functions.Function1)_function_1);
            Iterable _filter_1 = Iterables.filter((Iterable)_filter, EClass.class);
            _xifexpression = IterableExtensions.toSet((Iterable)_filter_1);
        } else {
            Iterable<EClassifier> _allConcreteRuleClassifiers = Ecore2XtextExtensions.allConcreteRuleClassifiers(it);
            Iterable _filter_2 = Iterables.filter(_allConcreteRuleClassifiers, EClass.class);
            Functions.Function1 _function_2 = c -> {
                EList _eAllReferences = c.getEAllReferences();
                Functions.Function1 _function_3 = r -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)r);
                Iterable _filter_3 = IterableExtensions.filter((Iterable)_eAllReferences, (Functions.Function1)_function_3);
                Functions.Function1 _function_4 = it_1 -> it_1.getEType();
                return IterableExtensions.map((Iterable)_filter_3, (Functions.Function1)_function_4);
            };
            Iterable _map_1 = IterableExtensions.map((Iterable)_filter_2, (Functions.Function1)_function_2);
            Iterable _flatten_1 = Iterables.concat((Iterable)_map_1);
            Iterable _filter_3 = Iterables.filter((Iterable)_flatten_1, EClass.class);
            _xifexpression = IterableExtensions.toSet((Iterable)_filter_3);
        }
        return _xifexpression;
    }

    public static Collection<EPackage> allReferencedEPackages(Ecore2XtextConfiguration prjInfo) {
        Set<EPackageInfo> _ePackageInfos = prjInfo.getEPackageInfos();
        Functions.Function1 _function = it -> {
            EPackage _ePackage = it.getEPackage();
            return Ecore2XtextExtensions.allReferencedEPackages(_ePackage, true);
        };
        Iterable _map = IterableExtensions.map(_ePackageInfos, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        return IterableExtensions.toSet((Iterable)_flatten);
    }

    public static Set<EPackage> allReferencedEPackages(EPackage ePack, boolean includeCrossRefs) {
        Set<EClassifier> _allReferencedClassifiers = Ecore2XtextExtensions.allReferencedClassifiers(ePack, includeCrossRefs);
        Functions.Function1 _function = it -> it.getEPackage();
        Iterable _map = IterableExtensions.map(_allReferencedClassifiers, (Functions.Function1)_function);
        Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
        return IterableExtensions.toSet((Iterable)_filterNull);
    }

    public static Set<EClassifier> allReferencedClassifiers(EPackage ePack, boolean includeCrossRefs) {
        EList _eClassifiers = ePack.getEClassifiers();
        Iterable _filter = Iterables.filter((Iterable)_eClassifiers, EClass.class);
        Functions.Function1 _function = it -> {
            EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
            Functions.Function1 _function_1 = f -> Ecore2XtextExtensions.needsAssignment(f) && (includeCrossRefs || Ecore2XtextExtensions.isContainment(f));
            return IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function_1);
        };
        Iterable strFeatures = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)strFeatures);
        Functions.Function1 _function_1 = it -> it.getEType();
        Iterable _map = IterableExtensions.map((Iterable)_flatten, (Functions.Function1)_function_1);
        Set refTypes = IterableExtensions.toSet((Iterable)_map);
        EList _eClassifiers_1 = ePack.getEClassifiers();
        Iterable _plus = Iterables.concat((Iterable)_eClassifiers_1, (Iterable)refTypes);
        Set retVal = IterableExtensions.toSet((Iterable)_plus);
        EClassifier _eString = UniqueNameUtil.eString();
        retVal.add(_eString);
        return retVal;
    }

    private static void allAssignedClassifiers(EClass eClazz, Collection<EClassifier> acceptor) {
        EList _eAllStructuralFeatures = eClazz.getEAllStructuralFeatures();
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f);
        Iterable _filter = IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getEType();
        Iterable _map = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        List classifiers = IterableExtensions.toList((Iterable)_map);
        Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses(eClazz);
        Iterables.addAll((Collection)classifiers, _subClasses);
        classifiers.removeAll(acceptor);
        boolean _isEmpty = classifiers.isEmpty();
        if (_isEmpty) {
            return;
        }
        Iterables.addAll(acceptor, (Iterable)classifiers);
        Iterable _filter_1 = Iterables.filter((Iterable)classifiers, EClass.class);
        Consumer<EClass> _function_2 = c -> Ecore2XtextExtensions.allAssignedClassifiers(c, acceptor);
        _filter_1.forEach(_function_2);
    }

    public static String fqn(EClassifier it) {
        boolean _tripleEquals;
        String _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        String _uniqueName = null;
        if (_ePackage != null) {
            _uniqueName = UniqueNameUtil.uniqueName((ENamedElement)_ePackage);
        }
        boolean bl = _tripleEquals = _uniqueName == null;
        if (_tripleEquals) {
            String _name = it.getName();
            _xifexpression = Ecore2XtextExtensions.quoteIfNeccesary(_name);
        } else {
            EPackage _ePackage_1 = it.getEPackage();
            String _uniqueName_1 = UniqueNameUtil.uniqueName((ENamedElement)_ePackage_1);
            String _plus = _uniqueName_1 + "::";
            String _name_1 = it.getName();
            String _quoteIfNeccesary = Ecore2XtextExtensions.quoteIfNeccesary(_name_1);
            _xifexpression = _plus + _quoteIfNeccesary;
        }
        return _xifexpression;
    }

    public static Iterable<EStructuralFeature> prefixFeatures(EClass it) {
        EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f) && Ecore2XtextExtensions.isPrefixBooleanFeature(f);
        return IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
    }

    public static Iterable<EStructuralFeature> inlinedFeatures(EClass it) {
        EList _eAllStructuralFeatures = it.getEAllStructuralFeatures();
        Functions.Function1 _function = f -> Ecore2XtextExtensions.needsAssignment(f);
        Iterable _filter = IterableExtensions.filter((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        List features = IterableExtensions.toList((Iterable)_filter);
        EAttribute _idAttribute = Ecore2XtextExtensions.idAttribute(it);
        features.remove(_idAttribute);
        Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(it);
        List _list = IterableExtensions.toList(_prefixFeatures);
        features.removeAll(_list);
        return features;
    }

    public static boolean onlyOptionalFeatures(EClass it) {
        boolean _xblockexpression = false;
        Iterable<EStructuralFeature> _prefixFeatures = Ecore2XtextExtensions.prefixFeatures(it);
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable features = Iterables.concat(_prefixFeatures, _inlinedFeatures);
        Functions.Function1 _function = f -> f.isRequired();
        Iterable _filter = IterableExtensions.filter((Iterable)features, (Functions.Function1)_function);
        _xblockexpression = IterableExtensions.isEmpty((Iterable)_filter);
        return _xblockexpression;
    }

    public static String assignedRuleCall(EAttribute it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature((EStructuralFeature)it);
        if (_isPrefixBooleanFeature) {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = _plus + "'";
        } else {
            EClassifier _eType = it.getEType();
            _xifexpression = UniqueNameUtil.uniqueName((ENamedElement)_eType);
        }
        return _xifexpression;
    }

    public static String concreteRuleName(EClass it) {
        String _xifexpression = null;
        boolean _needsDispatcherRule = Ecore2XtextExtensions.needsDispatcherRule((EClassifier)it);
        _xifexpression = _needsDispatcherRule ? UniqueNameUtil.uniqueImplName((ENamedElement)it) : UniqueNameUtil.uniqueName((ENamedElement)it);
        return _xifexpression;
    }

    public static String dataTypeRuleBody(EDataType it) {
        String _switchResult = null;
        String _name = it.getName();
        if (_name != null) {
            switch (_name) {
                case "EBigDecimal": {
                    _switchResult = "INT? '.' INT";
                    break;
                }
                case "EBigInteger": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EBoolean": {
                    _switchResult = Ecore2XtextExtensions.booleanRuleBody();
                    break;
                }
                case "EBooleanObject": {
                    _switchResult = Ecore2XtextExtensions.booleanRuleBody();
                    break;
                }
                case "EByte": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EByteObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EChar": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ECharObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EDouble": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EDoubleObject": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EFloat": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EFloatObject": {
                    _switchResult = Ecore2XtextExtensions.decimalRuleBody();
                    break;
                }
                case "EInt": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EIntegerObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ELong": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "ELongObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EShort": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EShortObject": {
                    _switchResult = Ecore2XtextExtensions.intRuleBody();
                    break;
                }
                case "EString": {
                    _switchResult = "STRING | ID";
                    break;
                }
                default: {
                    String _name_1 = it.getName();
                    String _plus = "'" + _name_1;
                    _switchResult = _plus + "' /* TODO: implement this rule and an appropriate IValueConverter */";
                    break;
                }
            }
        } else {
            String _name_1 = it.getName();
            String _plus = "'" + _name_1;
            _switchResult = _plus + "' /* TODO: implement this rule and an appropriate IValueConverter */";
        }
        return _switchResult;
    }

    public static String intRuleBody() {
        return "'-'? INT";
    }

    public static String decimalRuleBody() {
        return "'-'? INT? '.' INT (('E'|'e') '-'? INT)?";
    }

    public static String booleanRuleBody() {
        return "'true' | 'false'";
    }

    public static String assignmentKeyword(EStructuralFeature it) {
        String _xifexpression = null;
        boolean _isPrefixBooleanFeature = Ecore2XtextExtensions.isPrefixBooleanFeature(it);
        if (_isPrefixBooleanFeature) {
            _xifexpression = "";
        } else {
            String _name = it.getName();
            String _plus = "'" + _name;
            _xifexpression = _plus + "' ";
        }
        return _xifexpression;
    }

    public static String quoteIfNeccesary(String str) {
        String _xifexpression = null;
        boolean _isXtextKeyword = Ecore2XtextExtensions.isXtextKeyword(str);
        _xifexpression = _isXtextKeyword ? "^" + str : str;
        return _xifexpression;
    }

    public static boolean isXtextKeyword(String str) {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{"returns", "generate", "terminal", "with", "hidden", "enum", "grammar", "import", "as", "current", "fragment", "EOF"});
        return _newArrayList.contains(str);
    }

    public static EAttribute idAttribute(EClass it) {
        EAttribute _xblockexpression = null;
        EAttribute idAttr = Ecore2XtextExtensions.idAttributeInternal(it);
        EAttribute _xifexpression = null;
        if (idAttr != null) {
            _xifexpression = idAttr;
        } else {
            EList _eAllAttributes = it.getEAllAttributes();
            Functions.Function1 _function = a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && Objects.equal((Object)a.getName(), (Object)"name") && Objects.equal((Object)a.getEType().getName(), (Object)"EString") && !a.isMany();
            _xifexpression = (EAttribute)IterableExtensions.findFirst((Iterable)_eAllAttributes, (Functions.Function1)_function);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private static EAttribute idAttributeInternal(EClass it) {
        EList _eAllAttributes = it.getEAllAttributes();
        Functions.Function1 _function = a -> Ecore2XtextExtensions.needsAssignment((EStructuralFeature)a) && a.isID();
        return (EAttribute)IterableExtensions.findFirst((Iterable)_eAllAttributes, (Functions.Function1)_function);
    }

    public static boolean isBoolean(EClassifier it) {
        return it instanceof EDataType && CollectionLiterals.newArrayList((Object[])new String[]{"EBoolean", "EBooleanObject"}).contains(it.getName()) && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isPrefixBooleanFeature(EStructuralFeature it) {
        return Ecore2XtextExtensions.isBoolean(it.getEType()) && !it.isMany() && !Objects.equal((Object)it.getDefaultValueLiteral(), (Object)"true");
    }

    public static boolean isString(EClassifier it) {
        return it instanceof EDataType && Objects.equal((Object)it.getName(), (Object)"EString") && Ecore2XtextExtensions.isEcoreType(it);
    }

    public static boolean isEcoreType(EClassifier it) {
        EPackage _ePackage = it.getEPackage();
        String _nsURI = null;
        if (_ePackage != null) {
            _nsURI = _ePackage.getNsURI();
        }
        return Objects.equal((Object)_nsURI, (Object)"http://www.eclipse.org/emf/2002/Ecore");
    }

    public static boolean isID(EStructuralFeature it) {
        return it instanceof EAttribute && ((EAttribute)EAttribute.class.cast(it)).isID();
    }

    public static boolean needsAssignment(EStructuralFeature it) {
        return !(it.isDerived() || it.isTransient() || it instanceof EReference && ((EReference)EReference.class.cast(it)).isContainer() || it.getEType() instanceof EDataType && !((EDataType)EDataType.class.cast(it.getEType())).isSerializable());
    }

    public static boolean needsConcreteRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eClassifier instanceof EClass) {
            _matched = true;
            boolean bl = _switchResult = !((EClass)eClassifier).isAbstract() && !((EClass)eClassifier).isInterface();
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    public static boolean needsDispatcherRule(EClassifier eClassifier) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eClassifier instanceof EClass) {
            Functions.Function1 _function;
            _matched = true;
            Iterable<EClass> _subClasses = Ecore2XtextExtensions.subClasses((EClass)eClassifier);
            Iterable _filter = IterableExtensions.filter(_subClasses, (Functions.Function1)(_function = c -> Ecore2XtextExtensions.needsConcreteRule((EClassifier)c)));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _switchResult = !_isEmpty;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static boolean isContainment(EStructuralFeature eStrFeat) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (eStrFeat instanceof EAttribute) {
            _matched = true;
            _switchResult = true;
        }
        if (!_matched && eStrFeat instanceof EReference) {
            _matched = true;
            _switchResult = ((EReference)eStrFeat).isContainment();
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    public static Iterable<EClass> subClasses(EClass it) {
        boolean _tripleEquals;
        Iterable _xifexpression = null;
        EPackage _ePackage = it.getEPackage();
        boolean bl = _tripleEquals = _ePackage == null;
        if (_tripleEquals) {
            _xifexpression = CollectionLiterals.emptyList();
        } else {
            EPackage _ePackage_1 = it.getEPackage();
            EList _eClassifiers = _ePackage_1.getEClassifiers();
            Iterable _filter = Iterables.filter((Iterable)_eClassifiers, EClass.class);
            Functions.Function1 _function = c -> {
                EList _eAllSuperTypes = c.getEAllSuperTypes();
                return _eAllSuperTypes.contains((Object)it);
            };
            _xifexpression = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        }
        return _xifexpression;
    }

    public static Iterable<EAttribute> allAttributes(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        return Iterables.filter(_inlinedFeatures, EAttribute.class);
    }

    public static Iterable<EReference> allCrossReferences(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable _filter = Iterables.filter(_inlinedFeatures, EReference.class);
        Functions.Function1 _function = f -> {
            boolean _isContainment = f.isContainment();
            return !_isContainment;
        };
        return IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
    }

    public static Iterable<EReference> allContainmentReferences(EClass it) {
        Iterable<EStructuralFeature> _inlinedFeatures = Ecore2XtextExtensions.inlinedFeatures(it);
        Iterable _filter = Iterables.filter(_inlinedFeatures, EReference.class);
        Functions.Function1 _function = f -> f.isContainment();
        return IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
    }
}

