/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.util.Strings;

public class WhitespaceHelper {
    private static Logger LOG = Logger.getLogger(WhitespaceHelper.class);
    private int offset;
    private int length;
    private String prefix;
    private String suffix;
    private String lineSeparator;

    public void initialize(IDocument document, int offset, int length, boolean ensureEmptyLinesAround) {
        this.offset = offset;
        this.length = length;
        this.lineSeparator = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        if (ensureEmptyLinesAround) {
            this.prefix = this.calculateLeadingWhitespace(document);
            this.suffix = this.calculateTrailingWhitespace(document);
        }
    }

    public int getTotalOffset() {
        return this.offset;
    }

    public int getTotalLength() {
        return this.length;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    protected String calculateLeadingWhitespace(IDocument document) {
        block5: {
            try {
                IRegion line = document.getLineInformationOfOffset(this.offset);
                if (line == null) break block5;
                String linePrefix = document.get(line.getOffset(), this.offset - line.getOffset());
                if (Strings.isEmpty((String)linePrefix.trim())) {
                    int lineNr = document.getLineOfOffset(this.offset);
                    if (lineNr > 0) {
                        IRegion lineInformation = document.getLineInformation(lineNr - 1);
                        if (Strings.isEmpty((String)document.get(lineInformation.getOffset(), lineInformation.getLength()).trim())) {
                            int lineDelimiterLength = document.getLineDelimiter(lineNr - 1).length();
                            int skipLeadingWhitespace = linePrefix.length() + lineDelimiterLength;
                            this.offset -= skipLeadingWhitespace;
                            this.length += skipLeadingWhitespace;
                            return this.lineSeparator;
                        }
                        return this.lineSeparator;
                    }
                    break block5;
                }
                return String.valueOf(this.lineSeparator) + this.lineSeparator;
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error calculating leading whitespace", (Throwable)e);
            }
        }
        return null;
    }

    protected String calculateTrailingWhitespace(IDocument document) {
        block5: {
            try {
                IRegion line = document.getLineInformationOfOffset(this.offset + this.length);
                if (line == null) break block5;
                String lineSuffix = document.get(this.offset + this.length, line.getLength() - (this.offset + this.length - line.getOffset()));
                if (Strings.isEmpty((String)lineSuffix.trim())) {
                    IRegion lineInformation;
                    this.length += lineSuffix.length();
                    int lineNr = document.getLineOfOffset(this.offset + this.length);
                    if (lineNr < document.getNumberOfLines() - 1 && !Strings.isEmpty((String)document.get((lineInformation = document.getLineInformation(lineNr + 1)).getOffset(), lineInformation.getLength()).trim())) {
                        return this.lineSeparator;
                    }
                    break block5;
                }
                int i = 0;
                while (i < lineSuffix.length()) {
                    if (!Character.isWhitespace(lineSuffix.charAt(i))) break;
                    ++this.length;
                    ++i;
                }
                return String.valueOf(this.lineSeparator) + this.lineSeparator;
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error calculating trailing whitespace", (Throwable)e);
            }
        }
        return null;
    }
}

