/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.testing;

import java.util.Map;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.generator.InMemoryFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class RegisteringFileSystemAccess
extends InMemoryFileSystemAccess {
    @Accessors
    private final Set<GeneratedFile> generatedFiles = CollectionLiterals.newHashSet((Object[])new GeneratedFile[0]);
    @Accessors
    private String projectName;

    public void generateFile(String fileName, String outputConfigurationName, CharSequence contents) {
        super.generateFile(fileName, outputConfigurationName, contents);
        String path = this.getPath(fileName, outputConfigurationName);
        String _xifexpression = null;
        boolean _endsWith = fileName.endsWith(".java");
        if (_endsWith) {
            int _length = fileName.length();
            int _minus = _length - 5;
            String _substring = fileName.substring(0, _minus);
            _xifexpression = _substring.replace("/", ".");
        }
        String javaName = _xifexpression;
        GeneratedFile _generatedFile = new GeneratedFile(path, javaName, contents);
        this.generatedFiles.add(_generatedFile);
    }

    protected String getPath(String fileName, String outputConfigurationName) {
        Map _pathes = this.getPathes();
        String path = (String)_pathes.get(outputConfigurationName);
        return "/" + this.projectName + "/" + path + "/" + fileName;
    }

    @Pure
    public Set<GeneratedFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    @Pure
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Data
    public static class GeneratedFile {
        private final String path;
        private final String javaClassName;
        private final CharSequence contents;

        public GeneratedFile(String path, String javaClassName, CharSequence contents) {
            this.path = path;
            this.javaClassName = javaClassName;
            this.contents = contents;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.javaClassName == null ? 0 : this.javaClassName.hashCode());
            result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedFile other = (GeneratedFile)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            if (this.javaClassName == null ? other.javaClassName != null : !this.javaClassName.equals(other.javaClassName)) {
                return false;
            }
            return !(this.contents == null ? other.contents != null : !this.contents.equals(other.contents));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("path", (Object)this.path);
            b.add("javaClassName", (Object)this.javaClassName);
            b.add("contents", (Object)this.contents);
            return b.toString();
        }

        @Pure
        public String getPath() {
            return this.path;
        }

        @Pure
        public String getJavaClassName() {
            return this.javaClassName;
        }

        @Pure
        public CharSequence getContents() {
            return this.contents;
        }
    }
}

