/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib.internal;

import java.util.Map;
import javax.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.internal.ad;
import org.eclipse.xtext.xbase.lib.internal.ae;
import org.eclipse.xtext.xbase.lib.internal.af;
import org.eclipse.xtext.xbase.lib.internal.ai;
import org.eclipse.xtext.xbase.lib.internal.ax;
import org.eclipse.xtext.xbase.lib.internal.bm;
import org.eclipse.xtext.xbase.lib.internal.bq;
import org.eclipse.xtext.xbase.lib.internal.bs;
import org.eclipse.xtext.xbase.lib.internal.w;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class az<K, V>
extends ae<K, V> {
    private final transient bs<K, V>[] entries;
    private final transient bs<K, V>[] table;
    private final transient int mask;

    az(int size, bs.a<?, ?>[] theEntries) {
        this.entries = this.createEntryArray(size);
        int tableSize = w.closedTableSize(size, 1.2);
        this.table = this.createEntryArray(tableSize);
        this.mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            bs.a<?, ?> entry = theEntries[entryIndex];
            Object key = entry.getKey();
            int tableIndex = w.smear(key.hashCode()) & this.mask;
            bs<K, V> existing = this.table[tableIndex];
            bs newEntry = existing == null ? entry : new b((bs<?, ?>)entry, existing);
            this.table[tableIndex] = newEntry;
            this.entries[entryIndex] = newEntry;
            this.checkNoConflictInBucket(key, newEntry, existing);
        }
    }

    az(Map.Entry<?, ?>[] theEntries) {
        int size = theEntries.length;
        this.entries = this.createEntryArray(size);
        int tableSize = w.closedTableSize(size, 1.2);
        this.table = this.createEntryArray(tableSize);
        this.mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            Map.Entry<?, ?> entry = theEntries[entryIndex];
            Object key = entry.getKey();
            Object value = entry.getValue();
            bq.checkEntryNotNull(key, value);
            int tableIndex = w.smear(key.hashCode()) & this.mask;
            bs<K, V> existing = this.table[tableIndex];
            bs newEntry = existing == null ? new bs.a(key, value) : new b(key, value, existing);
            this.table[tableIndex] = newEntry;
            this.entries[entryIndex] = newEntry;
            this.checkNoConflictInBucket(key, newEntry, existing);
        }
    }

    private void checkNoConflictInBucket(K key, bs<K, V> entry, bs<K, V> bucketHead) {
        while (bucketHead != null) {
            az.checkNoConflict(!key.equals(bucketHead.getKey()), "key", entry, bucketHead);
            bucketHead = bucketHead.getNextInKeyBucket();
        }
    }

    private bs<K, V>[] createEntryArray(int size) {
        return new bs[size];
    }

    @Override
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int index = w.smear(key.hashCode()) & this.mask;
        for (bs<K, V> entry = this.table[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ai<Map.Entry<K, V>> createEntrySet() {
        return new a();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class a
    extends af<K, V> {
        private a() {
        }

        @Override
        ae<K, V> map() {
            return az.this;
        }

        @Override
        public bm<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ad<Map.Entry<K, V>> createAsList() {
            return new ax(this, az.this.entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class b<K, V>
    extends bs<K, V> {
        private final bs<K, V> nextInKeyBucket;

        b(K key, V value, bs<K, V> nextInKeyBucket) {
            super(key, value);
            this.nextInKeyBucket = nextInKeyBucket;
        }

        b(bs<K, V> contents, bs<K, V> nextInKeyBucket) {
            super(contents);
            this.nextInKeyBucket = nextInKeyBucket;
        }

        @Override
        bs<K, V> getNextInKeyBucket() {
            return this.nextInKeyBucket;
        }
    }
}

