/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class FunctionExtensions {
    @Pure
    public static <P1, RESULT> Functions.Function0<RESULT> curry(final Functions.Function1<? super P1, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function0<RESULT>(){

            @Override
            public RESULT apply() {
                return function.apply(argument);
            }
        };
    }

    @Pure
    public static <P1, P2, RESULT> Functions.Function1<P2, RESULT> curry(final Functions.Function2<? super P1, ? super P2, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function1<P2, RESULT>(){

            @Override
            public RESULT apply(P2 p2) {
                return function.apply(argument, p2);
            }
        };
    }

    @Pure
    public static <P1, P2, P3, RESULT> Functions.Function2<P2, P3, RESULT> curry(final Functions.Function3<? super P1, ? super P2, ? super P3, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function2<P2, P3, RESULT>(){

            @Override
            public RESULT apply(P2 p2, P3 p3) {
                return function.apply(argument, p2, p3);
            }
        };
    }

    @Pure
    public static <P1, P2, P3, P4, RESULT> Functions.Function3<P2, P3, P4, RESULT> curry(final Functions.Function4<? super P1, ? super P2, ? super P3, ? super P4, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function3<P2, P3, P4, RESULT>(){

            @Override
            public RESULT apply(P2 p2, P3 p3, P4 p4) {
                return function.apply(argument, p2, p3, p4);
            }
        };
    }

    @Pure
    public static <P1, P2, P3, P4, P5, RESULT> Functions.Function4<P2, P3, P4, P5, RESULT> curry(final Functions.Function5<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function4<P2, P3, P4, P5, RESULT>(){

            @Override
            public RESULT apply(P2 p2, P3 p3, P4 p4, P5 p5) {
                return function.apply(argument, p2, p3, p4, p5);
            }
        };
    }

    @Pure
    public static <P1, P2, P3, P4, P5, P6, RESULT> Functions.Function5<P2, P3, P4, P5, P6, RESULT> curry(final Functions.Function6<? super P1, ? super P2, ? super P3, ? super P4, ? super P5, ? super P6, ? extends RESULT> function, final P1 argument) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        return new Functions.Function5<P2, P3, P4, P5, P6, RESULT>(){

            @Override
            public RESULT apply(P2 p2, P3 p3, P4 p4, P5 p5, P6 p6) {
                return function.apply(argument, p2, p3, p4, p5, p6);
            }
        };
    }

    public static <V, T, R> Functions.Function1<V, R> compose(final Functions.Function1<? super T, ? extends R> after, final Functions.Function1<? super V, ? extends T> before) {
        if (after == null) {
            throw new NullPointerException("after");
        }
        if (before == null) {
            throw new NullPointerException("before");
        }
        return new Functions.Function1<V, R>(){

            @Override
            public R apply(V v2) {
                return after.apply(before.apply(v2));
            }
        };
    }

    public static <V, T, R> Functions.Function1<V, R> andThen(Functions.Function1<? super V, ? extends T> before, Functions.Function1<? super T, ? extends R> after) {
        return FunctionExtensions.compose(after, before);
    }

    public static <V1, V2, T, R> Functions.Function2<V1, V2, R> andThen(final Functions.Function2<? super V1, ? super V2, ? extends T> before, final Functions.Function1<? super T, ? extends R> after) {
        if (after == null) {
            throw new NullPointerException("after");
        }
        if (before == null) {
            throw new NullPointerException("before");
        }
        return new Functions.Function2<V1, V2, R>(){

            @Override
            public R apply(V1 v1, V2 v2) {
                return after.apply(before.apply(v1, v2));
            }
        };
    }

    public static <T> Procedures.Procedure1<T> andThen(final Procedures.Procedure1<? super T> before, final Procedures.Procedure1<? super T> after) {
        if (after == null) {
            throw new NullPointerException("after");
        }
        if (before == null) {
            throw new NullPointerException("before");
        }
        return new Procedures.Procedure1<T>(){

            @Override
            public void apply(T p2) {
                before.apply(p2);
                after.apply(p2);
            }
        };
    }

    public static Procedures.Procedure0 andThen(final Procedures.Procedure0 before, final Procedures.Procedure0 after) {
        if (after == null) {
            throw new NullPointerException("after");
        }
        if (before == null) {
            throw new NullPointerException("before");
        }
        return new Procedures.Procedure0(){

            @Override
            public void apply() {
                before.apply();
                after.apply();
            }
        };
    }
}

