/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.IServiceResult;
import org.eclipse.xtext.web.server.IUnwrappableServiceResult;
import org.eclipse.xtext.web.server.InvalidRequestException;
import org.eclipse.xtext.web.server.XtextServiceDispatcher;
import org.eclipse.xtext.web.servlet.HttpServiceContext;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class XtextServlet
extends HttpServlet {
    private static final long serialVersionUID = -6273795508296110114L;
    private final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private final IResourceServiceProvider.Registry serviceProviderRegistry = IResourceServiceProvider.Registry.INSTANCE;
    private final Gson gson = new Gson();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            super.service(req, resp);
        }
        catch (InvalidRequestException.ResourceNotFoundException exception) {
            this.LOG.trace((Object)("Invalid request (" + req.getRequestURI() + "): " + exception.getMessage()));
            resp.sendError(404, exception.getMessage());
        }
        catch (InvalidRequestException.InvalidDocumentStateException exception) {
            this.LOG.trace((Object)("Invalid request (" + req.getRequestURI() + "): " + exception.getMessage()));
            resp.sendError(409, exception.getMessage());
        }
        catch (InvalidRequestException.PermissionDeniedException exception) {
            this.LOG.trace((Object)("Invalid request (" + req.getRequestURI() + "): " + exception.getMessage()));
            resp.sendError(403, exception.getMessage());
        }
        catch (InvalidRequestException exception) {
            this.LOG.trace((Object)("Invalid request (" + req.getRequestURI() + "): " + exception.getMessage()));
            resp.sendError(400, exception.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        if (!service.isHasConflict() && (service.isHasSideEffects() || this.hasTextInput(service))) {
            super.doGet(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        String type = service.getContext().getParameter("serviceType");
        if (!service.isHasConflict() && !Objects.equal((Object)type, (Object)"update")) {
            super.doPut(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        XtextServiceDispatcher.ServiceDescriptor service = this.getService(req);
        String type = service.getContext().getParameter("serviceType");
        if (!service.isHasConflict() && (!service.isHasSideEffects() && !this.hasTextInput(service) || Objects.equal((Object)type, (Object)"update"))) {
            super.doPost(req, resp);
        } else {
            this.doService(service, resp);
        }
    }

    protected boolean hasTextInput(XtextServiceDispatcher.ServiceDescriptor service) {
        Set parameterKeys = service.getContext().getParameterKeys();
        return parameterKeys.contains("fullText") || parameterKeys.contains("deltaText");
    }

    protected XtextServiceDispatcher.ServiceDescriptor getService(HttpServletRequest request) throws InvalidRequestException {
        HttpServiceContext serviceContext = new HttpServiceContext(request);
        Injector injector = this.getInjector(serviceContext);
        XtextServiceDispatcher serviceDispatcher = (XtextServiceDispatcher)injector.getInstance(XtextServiceDispatcher.class);
        XtextServiceDispatcher.ServiceDescriptor service = serviceDispatcher.getService((IServiceContext)serviceContext);
        return service;
    }

    protected void doService(XtextServiceDispatcher.ServiceDescriptor service, HttpServletResponse response) {
        try {
            IServiceResult result = (IServiceResult)service.getService().apply();
            response.setStatus(200);
            response.setCharacterEncoding(this.getEncoding(service, result));
            response.setHeader("Cache-Control", "no-cache");
            if (result instanceof IUnwrappableServiceResult && ((IUnwrappableServiceResult)result).getContent() != null) {
                IUnwrappableServiceResult unwrapResult = (IUnwrappableServiceResult)result;
                String contentType = null;
                contentType = unwrapResult.getContentType() != null ? unwrapResult.getContentType() : "text/plain";
                response.setContentType(contentType);
                response.getWriter().write(unwrapResult.getContent());
            } else {
                response.setContentType("text/x-json");
                this.gson.toJson((Object)result, (Appendable)response.getWriter());
            }
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected String getEncoding(XtextServiceDispatcher.ServiceDescriptor service, IServiceResult result) {
        return "UTF-8";
    }

    protected Injector getInjector(HttpServiceContext serviceContext) throws InvalidRequestException.UnknownLanguageException {
        IResourceServiceProvider resourceServiceProvider = null;
        String parameter = serviceContext.getParameter("resource");
        if (parameter == null) {
            parameter = "";
        }
        URI emfURI = URI.createURI((String)parameter);
        String contentType = serviceContext.getParameter("contentType");
        if (Strings.isNullOrEmpty((String)contentType)) {
            resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI);
            if (resourceServiceProvider == null) {
                if (emfURI.toString().isEmpty()) {
                    throw new InvalidRequestException.UnknownLanguageException("Unable to identify the Xtext language: missing parameter 'resource' or 'contentType'.");
                }
                throw new InvalidRequestException.UnknownLanguageException("Unable to identify the Xtext language for resource " + emfURI + ".");
            }
        } else {
            resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(emfURI, contentType);
            if (resourceServiceProvider == null) {
                throw new InvalidRequestException.UnknownLanguageException("Unable to identify the Xtext language for contentType " + contentType + ".");
            }
        }
        return (Injector)resourceServiceProvider.get(Injector.class);
    }
}

