/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.web.servlet;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.xtext.web.server.IServiceContext;
import org.eclipse.xtext.web.server.ISession;
import org.eclipse.xtext.web.servlet.HttpSessionWrapper;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class HttpServiceContext
implements IServiceContext {
    private final HttpServletRequest request;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private HttpSessionWrapper sessionWrapper;

    public HttpServiceContext(HttpServletRequest request) {
        this.request = request;
        this.initializeParameters();
    }

    private String initializeParameters() {
        try {
            String[] contentType = null;
            if (this.request.getContentType() != null) {
                contentType = this.request.getContentType().split(";(\\s*)");
            }
            if (contentType != null && "application/x-www-form-urlencoded".equals(contentType[0])) {
                String[] encodedParams;
                String charset = null;
                charset = contentType != null && contentType.length >= 2 && contentType[1].startsWith("charset=") ? contentType[1].substring("charset=".length()) : Charset.defaultCharset().toString();
                for (String param : encodedParams = CharStreams.toString((Readable)this.request.getReader()).split("&")) {
                    int nameEnd = param.indexOf("=");
                    if (nameEnd <= 0) continue;
                    String key = param.substring(0, nameEnd);
                    String value = URLDecoder.decode(param.substring(nameEnd + 1), charset);
                    this.parameters.put(key, value);
                }
            }
            Enumeration paramNames = this.request.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String name = (String)paramNames.nextElement();
                this.parameters.put(name, this.request.getParameter(name));
            }
            if (!this.parameters.containsKey("serviceType")) {
                String substring = null;
                if (this.request.getPathInfo() != null) {
                    substring = this.request.getPathInfo().substring(1);
                }
                return this.parameters.put("serviceType", substring);
            }
            return null;
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    public Set<String> getParameterKeys() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public ISession getSession() {
        if (this.sessionWrapper == null) {
            this.sessionWrapper = new HttpSessionWrapper(this.request.getSession(true));
        }
        return this.sessionWrapper;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

