/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.smoketest.internal;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.testing.smoketest.ProcessedBy;
import org.eclipse.xtext.testing.smoketest.Scenario;
import org.eclipse.xtext.testing.smoketest.internal.CompleteInputScenarioRunner;
import org.eclipse.xtext.testing.smoketest.internal.ParallelCompleteInputScenarioRunner;
import org.eclipse.xtext.testing.smoketest.internal.ParallelPermutingScenarioRunner;
import org.eclipse.xtext.testing.smoketest.internal.PermutingScenarioRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

@Beta
public class AllScenariosRunner
extends ParentRunner<Runner> {
    private final List<Runner> runners = Lists.newArrayList();

    public AllScenariosRunner(Class<?> testClass, ProcessedBy processor, Scenario[] scenarios) throws InitializationError {
        super(testClass);
        if (processor.processCompleteInput()) {
            if (processor.processInParallel()) {
                this.runners.add((Runner)new ParallelCompleteInputScenarioRunner(testClass, processor.value()));
            } else {
                this.runners.add((Runner)new CompleteInputScenarioRunner(testClass, processor.value()));
            }
        } else if (processor.processInParallel()) {
            for (Scenario scenario : scenarios) {
                this.runners.add((Runner)new ParallelPermutingScenarioRunner(testClass, scenario, processor.value()));
            }
        } else {
            for (Scenario scenario : scenarios) {
                this.runners.add((Runner)new PermutingScenarioRunner(testClass, processor.value(), scenario));
            }
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    protected Description describeChild(Runner child) {
        return child.getDescription();
    }

    protected void runChild(Runner child, RunNotifier notifier) {
        child.run(notifier);
    }
}

