/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl.javasupport;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.xtext.builder.impl.IQueuedBuildDataContribution;
import org.eclipse.xtext.builder.impl.javasupport.UnconfirmedStructuralChangesDelta;
import org.eclipse.xtext.common.types.ui.notification.JavaBuilderState;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class JdtQueuedBuildData
implements IQueuedBuildDataContribution {
    private Map<String, JavaBuilderState> javaBuildState;
    private Map<String, JavaBuilderState> javaBuildStateCopy;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltas;
    private Collection<UnconfirmedStructuralChangesDelta> unconfirmedDeltasCopy;

    @Override
    public void reset() {
        ArrayList _newArrayList;
        HashMap _newHashMap;
        this.javaBuildState = _newHashMap = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        this.unconfirmedDeltas = _newArrayList = CollectionLiterals.newArrayList((Object[])new UnconfirmedStructuralChangesDelta[0]);
    }

    @Override
    public void reset(IProject project) {
        String _name = project.getName();
        this.javaBuildState.remove(_name);
    }

    public Collection<UnconfirmedStructuralChangesDelta> getUnconfirmedDeltas() {
        return Collections.unmodifiableCollection(this.unconfirmedDeltas);
    }

    @Override
    public boolean queueChange(IResourceDescription.Delta delta) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (delta instanceof UnconfirmedStructuralChangesDelta) {
            _matched = true;
            boolean _xblockexpression = false;
            IProject project = ((UnconfirmedStructuralChangesDelta)delta).getProject();
            String _name = project.getName();
            JavaBuilderState state = this.javaBuildState.get(_name);
            boolean _equals = Objects.equal((Object)state, null);
            if (_equals) {
                JavaBuilderState _lastBuiltState;
                String _name_1 = project.getName();
                JavaBuilderState _state = state = (_lastBuiltState = JavaBuilderState.getLastBuiltState((IProject)project));
                this.javaBuildState.put(_name_1, _state);
            }
            Integer _buildNumber = state.getBuildNumber();
            ((UnconfirmedStructuralChangesDelta)delta).setBuildNumber(_buildNumber);
            this.unconfirmedDeltas.add((UnconfirmedStructuralChangesDelta)delta);
            _switchResult = _xblockexpression = true;
        }
        if (!_matched) {
            _switchResult = false;
        }
        return _switchResult;
    }

    @Override
    public boolean needsRebuild(IProject it, final Collection<IResourceDescription.Delta> deltas) {
        Procedures.Procedure1<UnconfirmedStructuralChangesDelta> _function;
        boolean _xblockexpression = false;
        String _name = it.getName();
        JavaBuilderState oldState = this.javaBuildState.get(_name);
        final JavaBuilderState newState = JavaBuilderState.getLastBuiltState((IProject)it);
        Procedures.Procedure1<UnconfirmedStructuralChangesDelta> _xifexpression = null;
        _xifexpression = Objects.equal((Object)oldState, null) || !Objects.equal((Object)oldState.getLastStructuralBuildTime(), (Object)newState.getLastStructuralBuildTime()) ? (_function = new Procedures.Procedure1<UnconfirmedStructuralChangesDelta>(){

            public void apply(UnconfirmedStructuralChangesDelta it) {
                Set structurallyChangedTypes = newState.getStructurallyChangedTypes();
                if (JdtQueuedBuildData.this.namesIntersect(it.getNew(), structurallyChangedTypes) || JdtQueuedBuildData.this.namesIntersect(it.getOld(), structurallyChangedTypes)) {
                    deltas.add(it);
                }
            }
        }) : null;
        _xblockexpression = this.doNeedRebuild(newState, (Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta>)_xifexpression);
        return _xblockexpression;
    }

    protected boolean doNeedRebuild(JavaBuilderState it, Procedures.Procedure1<? super UnconfirmedStructuralChangesDelta> processor) {
        boolean _xblockexpression = false;
        Iterator<UnconfirmedStructuralChangesDelta> i = this.unconfirmedDeltas.iterator();
        while (i.hasNext()) {
            boolean _notEquals;
            UnconfirmedStructuralChangesDelta unconfirmed = i.next();
            if (unconfirmed.getBuildNumber() >= it.getBuildNumber() || !unconfirmed.getProject().equals((Object)it.getProject())) continue;
            i.remove();
            boolean bl = _notEquals = !Objects.equal(processor, null);
            if (!_notEquals) continue;
            processor.apply((Object)unconfirmed);
        }
        int _size = this.unconfirmedDeltas.size();
        _xblockexpression = _size != 0;
        return _xblockexpression;
    }

    protected boolean namesIntersect(IResourceDescription resourceDescription, Set<QualifiedName> names) {
        boolean _xblockexpression = false;
        boolean _equals = Objects.equal((Object)resourceDescription, null);
        if (_equals) {
            return false;
        }
        Iterable _exportedObjects = resourceDescription.getExportedObjects();
        for (IEObjectDescription objectDescription : _exportedObjects) {
            QualifiedName _qualifiedName = objectDescription.getQualifiedName();
            boolean _contains = names.contains(_qualifiedName);
            if (!_contains) continue;
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    @Override
    public void createCheckpoint() {
        HashMap<String, JavaBuilderState> _hashMap = new HashMap<String, JavaBuilderState>(this.javaBuildState);
        this.javaBuildStateCopy = _hashMap;
        ArrayList<UnconfirmedStructuralChangesDelta> _arrayList = new ArrayList<UnconfirmedStructuralChangesDelta>(this.unconfirmedDeltas);
        this.unconfirmedDeltasCopy = _arrayList;
    }

    @Override
    public void discardCheckpoint() {
        this.javaBuildStateCopy = null;
        this.unconfirmedDeltasCopy = null;
    }

    @Override
    public void rollback() {
        this.javaBuildState.clear();
        this.javaBuildState.putAll(this.javaBuildStateCopy);
        this.unconfirmedDeltas.clear();
        this.unconfirmedDeltas.addAll(this.unconfirmedDeltasCopy);
    }
}

