/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.compiler.batch.BatchCompiler;
import org.eclipse.xtext.builder.standalone.compiler.CompilerConfiguration;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class EclipseJavaCompiler
implements IJavaCompiler {
    @Inject
    private CompilerConfiguration configuration;
    private Iterable<String> classPath;
    private Writer errorWriter;
    private Writer outputWriter;
    private static final Logger LOG = Logger.getLogger(EclipseJavaCompiler.class);

    @Override
    public IJavaCompiler.CompilationResult compile(Iterable<String> sourceRoots, File outputClassDirectory) {
        Iterable validClasspath;
        Iterable validSourceRoots = IterableExtensions.filter(sourceRoots, (Functions.Function1)new EmptyOrMissingFilter());
        if (!this.containsJavaFiles(validSourceRoots)) {
            return IJavaCompiler.CompilationResult.SKIPPED;
        }
        ArrayList commandLine = Lists.newArrayList();
        if (this.configuration.isVerbose()) {
            commandLine.add("-verbose");
        }
        if (this.classPath != null && (validClasspath = IterableExtensions.filter(this.classPath, (Functions.Function1)new EmptyOrMissingFilter())).iterator().hasNext()) {
            commandLine.add("-cp \"" + Strings.concat((String)File.pathSeparator, (List)Lists.newArrayList((Iterable)validClasspath)) + "\"");
        }
        commandLine.add("-d \"" + outputClassDirectory.toString() + "\"");
        commandLine.add("-source " + this.configuration.getSourceLevel());
        commandLine.add("-target " + this.configuration.getTargetLevel());
        commandLine.add("-proceedOnError");
        for (String src : validSourceRoots) {
            commandLine.add("\"" + src + "\"");
        }
        String cmdLine = Strings.concat((String)" ", (List)commandLine);
        this.debugLog("invoke batch compiler with '" + cmdLine + "'");
        boolean result = BatchCompiler.compile((String)cmdLine, (PrintWriter)new PrintWriter(this.getOutputWriter()), (PrintWriter)new PrintWriter(this.getErrorWriter()), null);
        return result ? IJavaCompiler.CompilationResult.SUCCEEDED : IJavaCompiler.CompilationResult.FAILED;
    }

    public Writer getOutputWriter() {
        if (this.outputWriter == null) {
            this.outputWriter = new Writer(){

                @Override
                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim()) && EclipseJavaCompiler.this.configuration.isVerbose()) {
                        LOG.info((Object)message);
                    }
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        return this.outputWriter;
    }

    public void setOutputWriter(Writer ouputWriter) {
        this.outputWriter = ouputWriter;
    }

    public Writer getErrorWriter() {
        if (this.errorWriter == null) {
            this.errorWriter = new Writer(){

                @Override
                public void write(char[] data, int offset, int count) throws IOException {
                    String message = String.copyValueOf(data, offset, count);
                    if (!Strings.isEmpty((String)message.trim()) && EclipseJavaCompiler.this.configuration.isVerbose()) {
                        LOG.warn((Object)message);
                    }
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        return this.errorWriter;
    }

    public void setErrorWriter(Writer errorWriter) {
        this.errorWriter = errorWriter;
    }

    @Override
    public void setClassPath(Iterable<String> classPath) {
        this.classPath = classPath;
    }

    private boolean containsJavaFiles(Iterable<String> roots) {
        Multimap uris = new PathTraverser().resolvePathes((List)Lists.newArrayList(roots), (Predicate)new Predicate<URI>(){

            public boolean apply(URI input) {
                return "java".equals(input.fileExtension());
            }
        });
        return uris.values().size() > 0;
    }

    private void debugLog(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message);
        } else if (this.configuration.isVerbose()) {
            LOG.info((Object)message);
        }
    }

    @Override
    public CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    private final class EmptyOrMissingFilter
    implements Functions.Function1<String, Boolean> {
        private EmptyOrMissingFilter() {
        }

        public Boolean apply(String path) {
            File file = new File(path);
            boolean useEntry = file.exists();
            if (!useEntry) {
                EclipseJavaCompiler.this.debugLog("File '" + path + "' is missing. Skipping.");
            }
            return useEntry;
        }
    }
}

