/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.incremental.BuildContext;
import org.eclipse.xtext.builder.standalone.incremental.BuildRequest;
import org.eclipse.xtext.builder.standalone.incremental.FilesAndURIs;
import org.eclipse.xtext.mwe.NameBasedFilter;
import org.eclipse.xtext.mwe.PathTraverser;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ResourceURICollector {
    private static final Logger LOG = Logger.getLogger(ResourceURICollector.class);

    public Iterable<URI> collectAllResources(BuildRequest request, BuildContext context) {
        Set _xblockexpression = null;
        LOG.info((Object)"Collecting source models.");
        long startedAt = System.currentTimeMillis();
        List<URI> _sourceRoots = request.getSourceRoots();
        List<URI> _collectResources = this.collectResources(_sourceRoots, context);
        List<URI> _classPath = request.getClassPath();
        List<URI> _collectResources_1 = this.collectResources(_classPath, context);
        Iterable _plus = Iterables.concat(_collectResources, _collectResources_1);
        Set result = IterableExtensions.toSet((Iterable)_plus);
        long _currentTimeMillis = System.currentTimeMillis();
        long _minus = _currentTimeMillis - startedAt;
        String _plus_1 = "Finished collecting source models. Took: " + Long.valueOf(_minus);
        String _plus_2 = String.valueOf(_plus_1) + " ms.";
        LOG.debug((Object)_plus_2);
        _xblockexpression = result;
        return _xblockexpression;
    }

    protected List<URI> collectResources(List<URI> roots, BuildContext context) {
        Map<String, LanguageAccess> _languages = context.getLanguages();
        Set<String> _keySet = _languages.keySet();
        Iterable _plus = Iterables.concat(_keySet, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"java"})));
        String extensions = IterableExtensions.join((Iterable)_plus, (CharSequence)"|");
        final NameBasedFilter nameBasedFilter = new NameBasedFilter();
        nameBasedFilter.setRegularExpression(".*\\.(?:(" + extensions + "))$");
        final ArrayList resources = CollectionLiterals.newArrayList((Object[])new URI[0]);
        PathTraverser _pathTraverser = new PathTraverser();
        Functions.Function1<URI, String> _function = new Functions.Function1<URI, String>(){

            public String apply(URI it) {
                return it.toFileString();
            }
        };
        List _map = ListExtensions.map(roots, (Functions.Function1)_function);
        List _list = IterableExtensions.toList((Iterable)_map);
        Predicate<URI> _function_1 = new Predicate<URI>(){

            public boolean apply(URI input) {
                boolean matches = nameBasedFilter.matches(input);
                if (matches) {
                    LOG.info((Object)("Adding file '" + input + "'"));
                    resources.add(input);
                }
                return matches;
            }
        };
        Multimap modelsFound = _pathTraverser.resolvePathes(_list, (Predicate)_function_1);
        Map _asMap = modelsFound.asMap();
        Procedures.Procedure2<String, Collection<URI>> _function_2 = new Procedures.Procedure2<String, Collection<URI>>(){

            public void apply(String path, Collection<URI> resource) {
                boolean _isDirectory;
                boolean _not;
                boolean _notEquals;
                File file = new File(path);
                boolean _and = false;
                boolean _and_1 = false;
                boolean bl = _notEquals = !Objects.equal(resource, null);
                _and_1 = !_notEquals ? false : (_not = !(_isDirectory = file.isDirectory()));
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _endsWith;
                    String _name = file.getName();
                    _and = _endsWith = _name.endsWith(".jar");
                }
                if (_and) {
                    ResourceURICollector.this.registerBundle(file);
                }
            }
        };
        MapExtensions.forEach((Map)_asMap, (Procedures.Procedure2)_function_2);
        return resources;
    }

    protected void registerBundle(File file) {
        block34: {
            JarFile jarFile;
            block32: {
                String name;
                block33: {
                    Map _platformResourceMap;
                    boolean _containsKey;
                    boolean _notEquals;
                    Manifest manifest;
                    block31: {
                        JarFile _jarFile;
                        jarFile = null;
                        jarFile = _jarFile = new JarFile(file);
                        manifest = jarFile.getManifest();
                        boolean _equals = Objects.equal((Object)manifest, null);
                        if (!_equals) break block31;
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                        return;
                    }
                    Attributes _mainAttributes = manifest.getMainAttributes();
                    name = _mainAttributes.getValue("Bundle-SymbolicName");
                    boolean bl = _notEquals = !Objects.equal((Object)name, null);
                    if (!_notEquals) break block32;
                    int indexOf = name.indexOf(";");
                    if (indexOf > 0) {
                        String _substring;
                        name = _substring = name.substring(0, indexOf);
                    }
                    if (!(_containsKey = (_platformResourceMap = EcorePlugin.getPlatformResourceMap()).containsKey(name))) break block33;
                    try {
                        boolean _notEquals_1;
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                        if (_notEquals_1) {
                            jarFile.close();
                        }
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof IOException) {
                            IOException e_2 = (IOException)_t_1;
                            LOG.error((Object)jarFile, (Throwable)e_2);
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                    return;
                }
                try {
                    try {
                        URI _asURI = FilesAndURIs.asURI(file);
                        String _plus = "archive:" + _asURI;
                        String path = String.valueOf(_plus) + "!/";
                        Map _platformResourceMap_1 = EcorePlugin.getPlatformResourceMap();
                        URI _asURI_1 = FilesAndURIs.asURI(path);
                        _platformResourceMap_1.put(name, _asURI_1);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof ZipException) {
                            ZipException cfr_ignored_0 = (ZipException)_t;
                            String _absolutePath = file.getAbsolutePath();
                            String _plus_1 = "Could not open Jar file " + _absolutePath;
                            String _plus_2 = String.valueOf(_plus_1) + ".";
                            LOG.info((Object)_plus_2);
                        } else if (_t instanceof Exception) {
                            Exception e_1 = (Exception)_t;
                            String _absolutePath_1 = file.getAbsolutePath();
                            LOG.error((Object)_absolutePath_1, (Throwable)e_1);
                        } else {
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                            break block34;
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block34;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    block35: {
                        try {
                            boolean _notEquals_1;
                            boolean bl = _notEquals_1 = !Objects.equal(jarFile, null);
                            if (_notEquals_1) {
                                jarFile.close();
                            }
                        }
                        catch (Throwable _t_1) {
                            if (_t_1 instanceof IOException) {
                                IOException e_2 = (IOException)_t_1;
                                LOG.error((Object)jarFile, (Throwable)e_2);
                                break block35;
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t_1);
                        }
                    }
                    throw throwable;
                }
            }
            try {
                boolean _notEquals_1;
                boolean bl = _notEquals_1 = !Objects.equal((Object)jarFile, null);
                if (_notEquals_1) {
                    jarFile.close();
                }
            }
            catch (Throwable _t_1) {
                if (_t_1 instanceof IOException) {
                    IOException e_2 = (IOException)_t_1;
                    LOG.error((Object)jarFile, (Throwable)e_2);
                }
                throw Exceptions.sneakyThrow((Throwable)_t_1);
            }
        }
    }
}

