/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.compiler.IJavaCompiler;
import org.eclipse.xtext.builder.standalone.incremental.BuildContext;
import org.eclipse.xtext.builder.standalone.incremental.BuildRequest;
import org.eclipse.xtext.builder.standalone.incremental.FilesAndURIs;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.impl.TypeResourceServices;
import org.eclipse.xtext.common.types.descriptions.IStubGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaSupport {
    private static final Logger LOG = Logger.getLogger(JavaSupport.class);
    @Inject
    private TypeResourceServices typeResourceServices;
    @Inject
    private IndexedJvmTypeAccess typeAccess;
    @Inject
    private IJavaCompiler compiler;
    @Inject
    private JavaIoFileSystemAccess commonFileAccess;

    public void installLocalOnlyTypeProvider(Iterable<URI> classPathRoots, XtextResourceSet resourceSet) {
        LOG.info((Object)"Installing type provider for local types only");
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resourceSet, null, this.typeResourceServices);
        resourceSet.setClasspathURIContext((Object)classLoader);
    }

    public void installTypeProvider(Iterable<URI> classPathRoots, XtextResourceSet resSet) {
        LOG.info((Object)"Installing type provider with stubs");
        URLClassLoader classLoader = this.createURLClassLoader(classPathRoots);
        new ClasspathTypeProvider((ClassLoader)classLoader, (ResourceSet)resSet, this.typeAccess, this.typeResourceServices);
        resSet.setClasspathURIContext((Object)classLoader);
    }

    protected URLClassLoader createURLClassLoader(Iterable<URI> classPathEntries) {
        Functions.Function1<URI, URL> _function = new Functions.Function1<URI, URL>(){

            public URL apply(URI it) {
                try {
                    String _string = it.toString();
                    return new URL(_string);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        Iterable classPathUrls = IterableExtensions.map(classPathEntries, (Functions.Function1)_function);
        return new URLClassLoader((URL[])Conversions.unwrapArray((Object)classPathUrls, URL.class));
    }

    public URI preCompileJavaFiles(Iterable<URI> changedResources, ResourceDescriptionsData newIndex, BuildRequest request, @Extension BuildContext context) {
        try {
            final File stubsDir = this.createTmpDir("stubs", request);
            File javaDir = this.createTmpDir("java", request);
            String _absolutePath = stubsDir.getAbsolutePath();
            String _plus = "Generating stubs into " + _absolutePath;
            LOG.info((Object)_plus);
            String _absolutePath_1 = javaDir.getAbsolutePath();
            String _plus_1 = "Copying modified Java files into " + _absolutePath_1;
            LOG.info((Object)_plus_1);
            Procedures.Procedure1<JavaIoFileSystemAccess> _function = new Procedures.Procedure1<JavaIoFileSystemAccess>(){

                public void apply(JavaIoFileSystemAccess it) {
                    String _absolutePath = stubsDir.getAbsolutePath();
                    it.setOutputPath("DEFAULT_OUTPUT", _absolutePath);
                    it.setWriteTrace(false);
                }
            };
            ObjectExtensions.operator_doubleArrow((Object)this.commonFileAccess, (Procedures.Procedure1)_function);
            for (URI resource : changedResources) {
                String _fileExtension = resource.fileExtension();
                boolean _equals = Objects.equal((Object)_fileExtension, (Object)"java");
                if (_equals) {
                    URI relativeURI = FilesAndURIs.findSourceRootRelativeURI(resource, request);
                    boolean _equals_1 = Objects.equal((Object)relativeURI, null);
                    if (_equals_1) {
                        LOG.error((Object)("Changed java file " + resource + " is not in any sourceRoot"));
                        continue;
                    }
                    String _asPath = FilesAndURIs.asPath(resource);
                    File source = new File(_asPath);
                    String _string = relativeURI.toString();
                    File target = new File(javaDir, _string);
                    Files.createParentDirs((File)target);
                    Files.copy((File)source, (File)target);
                    continue;
                }
                LanguageAccess _languageAccess = context.getLanguageAccess(resource);
                boolean _isLinksAgainstJava = false;
                if (_languageAccess != null) {
                    _isLinksAgainstJava = _languageAccess.isLinksAgainstJava();
                }
                if (!_isLinksAgainstJava) continue;
                LanguageAccess _languageAccess_1 = context.getLanguageAccess(resource);
                IStubGenerator _stubGenerator = _languageAccess_1.getStubGenerator();
                IResourceDescription _resourceDescription = newIndex.getResourceDescription(resource);
                _stubGenerator.doGenerateStubs((IFileSystemAccess)this.commonFileAccess, _resourceDescription);
            }
            File stubsClasses = this.createTmpDir("stubs-classes", request);
            File javaClasses = this.createTmpDir("classes", request);
            this.compile(stubsDir, stubsClasses, request, new File[0]);
            this.compile(javaDir, javaClasses, request, stubsClasses);
            return FilesAndURIs.asURI(javaClasses);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void compile(File sourceDir, File targetDir, BuildRequest request, File ... additionalClassesFolders) {
        Functions.Function1<File, String> _function = new Functions.Function1<File, String>(){

            public String apply(File it) {
                return it.getAbsolutePath();
            }
        };
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)additionalClassesFolders)), (Functions.Function1)_function);
        List<URI> _outputs = request.getOutputs();
        Functions.Function1<URI, String> _function_1 = new Functions.Function1<URI, String>(){

            public String apply(URI it) {
                return FilesAndURIs.asPath(it);
            }
        };
        List _map_1 = ListExtensions.map(_outputs, (Functions.Function1)_function_1);
        Iterable _plus = Iterables.concat((Iterable)_map, (Iterable)_map_1);
        List<URI> _classPath = request.getClassPath();
        Functions.Function1<URI, String> _function_2 = new Functions.Function1<URI, String>(){

            public String apply(URI it) {
                return FilesAndURIs.asPath(it);
            }
        };
        List _map_2 = ListExtensions.map(_classPath, (Functions.Function1)_function_2);
        Iterable _plus_1 = Iterables.concat((Iterable)_plus, (Iterable)_map_2);
        this.compiler.setClassPath(_plus_1);
        String _absolutePath = sourceDir.getAbsolutePath();
        String _plus_2 = "Pre-compiling java files located in " + _absolutePath;
        LOG.info((Object)_plus_2);
        String _absolutePath_1 = sourceDir.getAbsolutePath();
        IJavaCompiler.CompilationResult result = this.compiler.compile(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_absolutePath_1})), targetDir);
        if (result != null) {
            switch (result) {
                case SKIPPED: {
                    LOG.info((Object)"Nothing to pre-compile.");
                    break;
                }
                case FAILED: {
                    LOG.info((Object)"Pre-compilation finished with errors. No need to worry. This is normal.");
                    break;
                }
                case SUCCEEDED: {
                    LOG.info((Object)"Pre-compilation successfully finished.");
                    break;
                }
            }
        }
    }

    protected File createTmpDir(String subDir, BuildRequest request) {
        try {
            boolean _exists_1;
            boolean _not_3;
            boolean _not_2;
            boolean _exists;
            boolean _not_1;
            boolean _not;
            URI _baseDir = request.getBaseDir();
            File _asFile = FilesAndURIs.asFile(_baseDir);
            File tmpRoot = new File(_asFile, "xtext-tmp");
            boolean _and = false;
            boolean _mkdirs = tmpRoot.mkdirs();
            boolean bl = _not = !_mkdirs;
            _and = !_not ? false : (_not_1 = !(_exists = tmpRoot.exists()));
            if (_and) {
                String _absolutePath = tmpRoot.getAbsolutePath();
                String _plus = "Failed to create directory '" + _absolutePath;
                String _plus_1 = String.valueOf(_plus) + "'";
                throw new IOException(_plus_1);
            }
            File tmpDir = new File(tmpRoot, subDir);
            boolean _and_1 = false;
            boolean _mkdirs_1 = tmpDir.mkdirs();
            boolean bl2 = _not_2 = !_mkdirs_1;
            _and_1 = !_not_2 ? false : (_not_3 = !(_exists_1 = tmpDir.exists()));
            if (_and_1) {
                String _absolutePath_1 = tmpDir.getAbsolutePath();
                String _plus_2 = "Failed to create directory '" + _absolutePath_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                throw new IOException(_plus_3);
            }
            return tmpDir;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

