/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.builder.standalone.LanguageAccess;
import org.eclipse.xtext.builder.standalone.incremental.ClusteringStorageAwareResourceLoader;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
@Accessors
public class BuildContext {
    private final Map<String, LanguageAccess> languages;
    private final XtextResourceSet resourceSet;
    private final IResourceClusteringPolicy clusteringPolicy;
    private final File tempDir;
    private ClusteringStorageAwareResourceLoader loader;

    public <T> Iterable<T> executeClustered(Iterable<URI> uri, Functions.Function1<? super Resource, ? extends T> operation) {
        Iterable<? extends T> _xblockexpression = null;
        boolean _equals = Objects.equal((Object)this.loader, null);
        if (_equals) {
            ClusteringStorageAwareResourceLoader _clusteringStorageAwareResourceLoader;
            this.loader = _clusteringStorageAwareResourceLoader = new ClusteringStorageAwareResourceLoader(this);
        }
        _xblockexpression = this.loader.executeClustered(uri, operation);
        return _xblockexpression;
    }

    public LanguageAccess getLanguageAccess(URI uri) {
        String _fileExtension = uri.fileExtension();
        return this.languages.get(_fileExtension);
    }

    public BuildContext(Map<String, LanguageAccess> languages, XtextResourceSet resourceSet, IResourceClusteringPolicy clusteringPolicy, File tempDir) {
        this.languages = languages;
        this.resourceSet = resourceSet;
        this.clusteringPolicy = clusteringPolicy;
        this.tempDir = tempDir;
    }

    @Pure
    public Map<String, LanguageAccess> getLanguages() {
        return this.languages;
    }

    @Pure
    public XtextResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Pure
    public IResourceClusteringPolicy getClusteringPolicy() {
        return this.clusteringPolicy;
    }

    @Pure
    public File getTempDir() {
        return this.tempDir;
    }

    @Pure
    public ClusteringStorageAwareResourceLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClusteringStorageAwareResourceLoader loader) {
        this.loader = loader;
    }
}

