/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.utilities.reader;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockPackage;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModelPackage;
import org.eclipse.vorto.core.api.model.mapping.MappingPackage;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.editor.functionblock.FunctionblockStandaloneSetup;
import org.eclipse.vorto.editor.infomodel.InformationModelStandaloneSetup;
import org.eclipse.vorto.editor.mapping.MappingStandaloneSetup;
import org.eclipse.vorto.model.ModelType;
import org.eclipse.vorto.utilities.reader.DefaultModelWorkspace;
import org.eclipse.vorto.utilities.reader.IModelWorkspace;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ModelWorkspaceReader {
    private WorkspaceFileReader fileReader;
    private List<WorkspaceZipReader> zipReaders = new ArrayList<WorkspaceZipReader>();

    public ModelWorkspaceReader() {
        this.fileReader = new WorkspaceFileReader();
    }

    public static void init() {
        FunctionblockPackage.eINSTANCE.eClass();
        InformationModelPackage.eINSTANCE.eClass();
        MappingPackage.eINSTANCE.eClass();
        FunctionblockStandaloneSetup.doSetup();
        InformationModelStandaloneSetup.doSetup();
        MappingStandaloneSetup.doSetup();
    }

    public ModelWorkspaceReader addFile(InputStream input, ModelType type) {
        this.fileReader.addFile(input, type);
        return this;
    }

    public ModelWorkspaceReader addZip(ZipInputStream zis) {
        this.zipReaders.add(new WorkspaceZipReader(zis));
        return this;
    }

    public IModelWorkspace read() {
        DefaultModelWorkspace workspace = new DefaultModelWorkspace();
        workspace.addModels(this.fileReader.read());
        this.zipReaders.stream().forEach(x -> workspace.addModels(x.read()));
        return workspace;
    }

    private static class ModelFile {
        private InputStream is;
        private ModelType type;

        public ModelFile(InputStream is, ModelType type) {
            this.is = is;
            this.type = type;
        }

        public InputStream getIs() {
            return this.is;
        }

        public ModelType getType() {
            return this.type;
        }
    }

    private static class WorkspaceFileReader {
        private List<ModelFile> files = new ArrayList<ModelFile>();

        private WorkspaceFileReader() {
        }

        public void addFile(InputStream input, ModelType type) {
            this.files.add(new ModelFile(input, type));
        }

        public List<Model> read() {
            Injector injector = new MappingStandaloneSetup().createInjectorAndDoEMFRegistration();
            XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_ENCODING, (Object)"UTF-8");
            ArrayList<Resource> infoModelResources = new ArrayList<Resource>();
            try {
                for (ModelFile modelFile : this.files) {
                    Resource resource = resourceSet.createResource(URI.createURI((String)("fake:/" + UUID.randomUUID().toString() + modelFile.getType().getExtension())));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)modelFile.getIs(), (OutputStream)baos);
                    resource.load((InputStream)new ByteArrayInputStream(baos.toByteArray()), resourceSet.getLoadOptions());
                    infoModelResources.add(resource);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Problem reading zip file", ex);
            }
            EcoreUtil2.resolveAll((ResourceSet)resourceSet);
            return infoModelResources.stream().map(r -> (Model)r.getContents().get(0)).collect(Collectors.toList());
        }
    }

    private static class WorkspaceZipReader {
        private ZipInputStream zis;

        public WorkspaceZipReader(ZipInputStream zis) {
            this.zis = zis;
        }

        public List<Model> read() {
            ZipEntry entry = null;
            Injector injector = new MappingStandaloneSetup().createInjectorAndDoEMFRegistration();
            XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
            resourceSet.addLoadOption((Object)XtextResource.OPTION_ENCODING, (Object)"UTF-8");
            ArrayList<Resource> infoModelResources = new ArrayList<Resource>();
            try {
                while ((entry = this.zis.getNextEntry()) != null) {
                    Resource resource = resourceSet.createResource(URI.createURI((String)("fake:/" + entry.getName())));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)this.zis, (OutputStream)baos);
                    resource.load((InputStream)new ByteArrayInputStream(baos.toByteArray()), resourceSet.getLoadOptions());
                    infoModelResources.add(resource);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Problem reading zip file", ex);
            }
            EcoreUtil2.resolveAll((ResourceSet)resourceSet);
            return infoModelResources.stream().map(r -> (Model)r.getContents().get(0)).collect(Collectors.toList());
        }
    }
}

