/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.plugin.generator.utils.javatemplates;

import org.eclipse.vorto.core.api.model.datatype.DictionaryPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyType;
import org.eclipse.vorto.core.api.model.datatype.Type;
import org.eclipse.vorto.plugin.generator.InvocationContext;
import org.eclipse.vorto.plugin.generator.utils.ITemplate;
import org.eclipse.vorto.plugin.generator.utils.javatemplates.ValueMapper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JavaClassFieldSetterTemplate
implements ITemplate<Property> {
    private String setterPrefix;

    public JavaClassFieldSetterTemplate(String setterPrefix) {
        this.setterPrefix = setterPrefix;
    }

    @Override
    public String getContent(Property property, InvocationContext invocationContext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/**");
        _builder.newLine();
        _builder.append("* Setter for ");
        String _name = property.getName();
        _builder.append(_name);
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        _builder.append("*/");
        _builder.newLine();
        PropertyType _type = property.getType();
        if (_type instanceof PrimitivePropertyType) {
            _builder.append("public void ");
            _builder.append(this.setterPrefix);
            String _normalize = ValueMapper.normalize(StringExtensions.toFirstUpper((String)property.getName()));
            _builder.append(_normalize);
            _builder.append("(");
            PropertyType _type_1 = property.getType();
            PrimitiveType _type_2 = ((PrimitivePropertyType)_type_1).getType();
            String _mapSimpleDatatype = ValueMapper.mapSimpleDatatype(_type_2);
            _builder.append(_mapSimpleDatatype);
            _builder.append(" ");
            String _normalize_1 = ValueMapper.normalize(property.getName());
            _builder.append(_normalize_1);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("this.");
            String _normalize_2 = ValueMapper.normalize(property.getName());
            _builder.append(_normalize_2, "\t");
            _builder.append(" = ");
            String _normalize_3 = ValueMapper.normalize(property.getName());
            _builder.append(_normalize_3, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        } else {
            PropertyType _type_3 = property.getType();
            if (_type_3 instanceof ObjectPropertyType) {
                PropertyType _type_4 = property.getType();
                ObjectPropertyType object = (ObjectPropertyType)_type_4;
                _builder.newLineIfNotEmpty();
                Type _type_5 = object.getType();
                if (_type_5 instanceof Entity) {
                    _builder.append("public void ");
                    _builder.append(this.setterPrefix);
                    String _normalize_4 = ValueMapper.normalize(StringExtensions.toFirstUpper((String)property.getName()));
                    _builder.append(_normalize_4);
                    _builder.append("(");
                    CharSequence _namespaceOfDatatype = this.getNamespaceOfDatatype();
                    _builder.append((Object)_namespaceOfDatatype);
                    Type _type_6 = object.getType();
                    String _firstUpper = StringExtensions.toFirstUpper((String)((Entity)_type_6).getName());
                    _builder.append(_firstUpper);
                    _builder.append(" ");
                    String _normalize_5 = ValueMapper.normalize(property.getName());
                    _builder.append(_normalize_5);
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("this.");
                    String _normalize_6 = ValueMapper.normalize(property.getName());
                    _builder.append(_normalize_6, "\t");
                    _builder.append(" = ");
                    String _normalize_7 = ValueMapper.normalize(property.getName());
                    _builder.append(_normalize_7, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("}");
                    _builder.newLine();
                } else {
                    Type _type_7 = object.getType();
                    if (_type_7 instanceof Enum) {
                        _builder.append("public void ");
                        _builder.append(this.setterPrefix);
                        String _normalize_8 = ValueMapper.normalize(StringExtensions.toFirstUpper((String)property.getName()));
                        _builder.append(_normalize_8);
                        _builder.append("(");
                        CharSequence _namespaceOfDatatype_1 = this.getNamespaceOfDatatype();
                        _builder.append((Object)_namespaceOfDatatype_1);
                        Type _type_8 = object.getType();
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)((Enum)_type_8).getName());
                        _builder.append(_firstUpper_1);
                        _builder.append(" ");
                        String _normalize_9 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_9);
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("this.");
                        String _normalize_10 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_10, "\t");
                        _builder.append(" = ");
                        String _normalize_11 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_11, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
            } else {
                PropertyType _type_9 = property.getType();
                if (_type_9 instanceof DictionaryPropertyType) {
                    PropertyType _type_10 = property.getType();
                    DictionaryPropertyType dictionary = (DictionaryPropertyType)_type_10;
                    _builder.newLineIfNotEmpty();
                    if (dictionary.getKeyType() != null && dictionary.getValueType() != null) {
                        _builder.append("public void ");
                        _builder.append(this.setterPrefix);
                        String _normalize_12 = ValueMapper.normalize(StringExtensions.toFirstUpper((String)property.getName()));
                        _builder.append(_normalize_12);
                        _builder.append("(java.util.Map<");
                        String _propertyType = this.getPropertyType(dictionary.getKeyType());
                        _builder.append(_propertyType);
                        _builder.append(",");
                        String _propertyType_1 = this.getPropertyType(dictionary.getValueType());
                        _builder.append(_propertyType_1);
                        _builder.append("> ");
                        String _normalize_13 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_13);
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("this.");
                        String _normalize_14 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_14, "\t");
                        _builder.append(" = ");
                        String _normalize_15 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_15, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        _builder.append("public void ");
                        _builder.append(this.setterPrefix);
                        String _normalize_16 = ValueMapper.normalize(StringExtensions.toFirstUpper((String)property.getName()));
                        _builder.append(_normalize_16);
                        _builder.append("(java.util.Map ");
                        String _normalize_17 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_17);
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("    ");
                        _builder.append("this.");
                        String _normalize_18 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_18, "    ");
                        _builder.append(" = ");
                        String _normalize_19 = ValueMapper.normalize(property.getName());
                        _builder.append(_normalize_19, "    ");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("}");
                        _builder.newLine();
                    }
                }
            }
        }
        return _builder.toString();
    }

    protected CharSequence getNamespaceOfDatatype() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    public String getPropertyType(PropertyType propertyType) {
        if (propertyType instanceof PrimitivePropertyType) {
            PrimitiveType _type = ((PrimitivePropertyType)propertyType).getType();
            return ValueMapper.mapSimpleDatatype(_type);
        }
        if (propertyType instanceof ObjectPropertyType) {
            CharSequence _namespaceOfDatatype = this.getNamespaceOfDatatype();
            String _firstUpper = StringExtensions.toFirstUpper((String)((ObjectPropertyType)propertyType).getType().getName());
            return _namespaceOfDatatype + _firstUpper;
        }
        return "java.util.Map";
    }
}

