/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.vorto.model.ModelEvent;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.runtime.PropertyValue;

public class FBEventValue {
    private ModelEvent meta;
    private List<PropertyValue> eventProperties = new ArrayList<PropertyValue>();

    public FBEventValue(ModelEvent meta) {
        this.meta = meta;
    }

    public void withProperty(String name, Object value) {
        Optional<ModelProperty> mp = this.meta.getProperties().stream().filter(p -> p.getName().equals(name)).findFirst();
        if (!mp.isPresent()) {
            throw new IllegalArgumentException("Event property with given name is not defined in Function Block Event Type");
        }
        this.eventProperties.add(new PropertyValue(mp.get(), value));
    }

    public List<PropertyValue> getProperties() {
        return Collections.unmodifiableList(this.eventProperties);
    }

    public ModelEvent getMeta() {
        return this.meta;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (PropertyValue eventProperty : this.eventProperties) {
            data.put(eventProperty.getMeta().getName(), eventProperty.getValue());
        }
        result.put(this.meta.getName(), data);
        return result;
    }
}

