/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.model.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vorto.model.ModelProperty;

public class ValidationReport {
    private List<ValidationReportItem> invalidProperties = new ArrayList<ValidationReportItem>();

    public void addItem(ModelProperty meta, String message) {
        this.invalidProperties.add(new ValidationReportItem(message, meta));
    }

    public void addReport(ValidationReport report) {
        this.invalidProperties.addAll(report.getItems());
    }

    public List<ValidationReportItem> getItems() {
        return Collections.unmodifiableList(this.invalidProperties);
    }

    public boolean isValid() {
        return this.invalidProperties.isEmpty();
    }

    public static class ValidationReportItem {
        private String message;
        private ModelProperty meta;

        public ValidationReportItem(String msg, ModelProperty meta) {
            this.message = msg;
            this.meta = meta;
        }

        private ValidationReportItem() {
        }

        public String getMessage() {
            return this.message;
        }

        public ModelProperty getType() {
            return this.meta;
        }
    }
}

