/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.mapping.engine.serializer.MappingIdUtils;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InformationModelMappingSerializer
extends AbstractSerializer {
    public InformationModelMappingSerializer(IMappingSpecification spec, ModelId modelId, String targetPlatform) {
        super(spec, modelId, targetPlatform);
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vortolang 1.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _namespace = this.modelId.getNamespace();
        _builder.append(_namespace);
        _builder.newLineIfNotEmpty();
        _builder.append("version ");
        String _version = this.modelId.getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("displayname \"");
        String _name = this.specification.getInfoModel().getId().getName();
        _builder.append(_name);
        _builder.append(" Payload Mapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append("description \"Payload Mapping for ");
        String _name_1 = this.specification.getInfoModel().getId().getName();
        _builder.append(_name_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using ");
        String _namespace_1 = this.specification.getInfoModel().getId().getNamespace();
        _builder.append(_namespace_1);
        _builder.append(".");
        String _name_2 = this.specification.getInfoModel().getId().getName();
        _builder.append(_name_2);
        _builder.append(";");
        String _version_1 = this.specification.getInfoModel().getId().getVersion();
        _builder.append(_version_1);
        _builder.newLineIfNotEmpty();
        HashSet<ModelId> imports = new HashSet<ModelId>();
        _builder.newLineIfNotEmpty();
        List _functionblocks = this.specification.getInfoModel().getFunctionblocks();
        Iterator iterator = _functionblocks.iterator();
        while (iterator.hasNext()) {
            ModelProperty fbProperty = (ModelProperty)iterator.next();
            boolean status = imports.add(MappingIdUtils.getIdForProperty(this.modelId, fbProperty));
            _builder.newLineIfNotEmpty();
        }
        for (ModelId importId : imports) {
            _builder.append("using ");
            String _namespace_2 = importId.getNamespace();
            _builder.append(_namespace_2);
            _builder.append(".");
            String _name_3 = importId.getName();
            _builder.append(_name_3);
            _builder.append(";");
            String _version_2 = importId.getVersion();
            _builder.append(_version_2);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("infomodelmapping ");
        String _name_4 = this.modelId.getName();
        _builder.append(_name_4);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("targetplatform ");
        _builder.append(this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(this.specification.getInfoModel().getStereotypes());
        for (Stereotype stereotype : _filterEmptyStereotypes) {
            _builder.append("\t");
            _builder.append("from ");
            String _name_5 = this.specification.getInfoModel().getId().getName();
            _builder.append(_name_5, "\t");
            _builder.append(" to ");
            String _name_6 = stereotype.getName();
            _builder.append(_name_6, "\t");
            _builder.append(" with {");
            String _createContent = this.createContent(stereotype.getAttributes());
            _builder.append(_createContent, "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
        }
        List _functionblocks_1 = this.specification.getInfoModel().getFunctionblocks();
        for (ModelProperty fbProperty_1 : _functionblocks_1) {
            _builder.append("\t");
            _builder.append("from ");
            String _name_7 = this.specification.getInfoModel().getId().getName();
            _builder.append(_name_7, "\t");
            _builder.append(".functionblocks.");
            String _name_8 = fbProperty_1.getName();
            _builder.append(_name_8, "\t");
            _builder.append(" to reference ");
            String _firstUpper = StringExtensions.toFirstUpper((String)fbProperty_1.getName());
            String _plus = _firstUpper + "PayloadMapping";
            _builder.append(_plus, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Predicate<Stereotype> _function = it -> {
            boolean _isEmpty = it.getAttributes().isEmpty();
            return !_isEmpty;
        };
        return stereotypes.stream().filter(_function).collect(Collectors.toList());
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            StringBuilder _append = content.append(key).append(":");
            String _escapeQuotes = this.escapeQuotes(attributes.get(key));
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }
}

