/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.mapping.engine.serializer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.vorto.mapping.engine.model.spec.IMappingSpecification;
import org.eclipse.vorto.mapping.engine.serializer.AbstractSerializer;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.ModelProperty;
import org.eclipse.vorto.model.Stereotype;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class InformationModelMappingSerializer
extends AbstractSerializer {
    public InformationModelMappingSerializer(IMappingSpecification spec, String targetPlatform) {
        super(spec, targetPlatform);
    }

    @Override
    public String serialize() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("vortolang 1.0");
        _builder.newLine();
        _builder.newLine();
        _builder.append("namespace ");
        String _namespace = this.specification.getInfoModel().getId().getNamespace();
        _builder.append(_namespace);
        _builder.append(".mapping.");
        String _lowerCase = this.specification.getInfoModel().getId().getName().toLowerCase();
        _builder.append(_lowerCase);
        _builder.newLineIfNotEmpty();
        _builder.append("version ");
        String _version = this.specification.getInfoModel().getId().getVersion();
        _builder.append(_version);
        _builder.newLineIfNotEmpty();
        _builder.append("displayname \"");
        String _name = this.specification.getInfoModel().getId().getName();
        _builder.append(_name);
        _builder.append(" Payload Mapping\"");
        _builder.newLineIfNotEmpty();
        _builder.append("description \"Payload Mapping for ");
        String _name_1 = this.specification.getInfoModel().getId().getName();
        _builder.append(_name_1);
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("category payloadmapping");
        _builder.newLine();
        _builder.newLine();
        _builder.append("using ");
        String _namespace_1 = this.specification.getInfoModel().getId().getNamespace();
        _builder.append(_namespace_1);
        _builder.append(".");
        String _name_2 = this.specification.getInfoModel().getId().getName();
        _builder.append(_name_2);
        _builder.append(";");
        String _version_1 = this.specification.getInfoModel().getId().getVersion();
        _builder.append(_version_1);
        _builder.newLineIfNotEmpty();
        HashSet<String> imports = new HashSet<String>();
        _builder.newLineIfNotEmpty();
        List _functionblocks = this.specification.getInfoModel().getFunctionblocks();
        Iterator iterator = _functionblocks.iterator();
        while (iterator.hasNext()) {
            ModelProperty fbProperty = (ModelProperty)iterator.next();
            String _namespace_2 = this.specification.getInfoModel().getId().getNamespace();
            String _plus = "using " + _namespace_2;
            String _plus_1 = _plus + ".mapping.";
            String _lowerCase_1 = this.specification.getInfoModel().getId().getName().toLowerCase();
            String _plus_2 = _plus_1 + _lowerCase_1;
            String _plus_3 = _plus_2 + ".fbs";
            String _plus_4 = _plus_3 + ".";
            String _firstUpper = StringExtensions.toFirstUpper((String)fbProperty.getName());
            String _plus_5 = _plus_4 + _firstUpper;
            String _plus_6 = _plus_5 + "PayloadMapping;";
            String _version_2 = this.specification.getInfoModel().getId().getVersion();
            String _plus_7 = _plus_6 + _version_2;
            boolean status = imports.add(_plus_7);
            _builder.newLineIfNotEmpty();
        }
        for (String using : imports) {
            _builder.append(using);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("infomodelmapping ");
        String _name_3 = this.specification.getInfoModel().getId().getName();
        _builder.append(_name_3);
        _builder.append("PayloadMapping {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("targetplatform ");
        _builder.append(this.targetPlatform, "\t");
        _builder.newLineIfNotEmpty();
        List<Stereotype> _filterEmptyStereotypes = this.filterEmptyStereotypes(this.specification.getInfoModel().getStereotypes());
        for (Stereotype stereotype : _filterEmptyStereotypes) {
            _builder.append("\t");
            _builder.append("from ");
            String _name_4 = this.specification.getInfoModel().getId().getName();
            _builder.append(_name_4, "\t");
            _builder.append(" to ");
            String _name_5 = stereotype.getName();
            _builder.append(_name_5, "\t");
            _builder.append(" with {");
            String _createContent = this.createContent(stereotype.getAttributes());
            _builder.append(_createContent, "\t");
            _builder.append("}");
            _builder.newLineIfNotEmpty();
        }
        List _functionblocks_1 = this.specification.getInfoModel().getFunctionblocks();
        for (ModelProperty fbProperty_1 : _functionblocks_1) {
            _builder.append("\t");
            _builder.append("from ");
            String _name_6 = this.specification.getInfoModel().getId().getName();
            _builder.append(_name_6, "\t");
            _builder.append(".functionblocks.");
            String _name_7 = fbProperty_1.getName();
            _builder.append(_name_7, "\t");
            _builder.append(" to reference ");
            String _firstUpper_1 = StringExtensions.toFirstUpper((String)fbProperty_1.getName());
            String _plus_8 = _firstUpper_1 + "PayloadMapping";
            _builder.append(_plus_8, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private List<Stereotype> filterEmptyStereotypes(List<Stereotype> stereotypes) {
        Predicate<Stereotype> _function = it -> {
            boolean _isEmpty = it.getAttributes().isEmpty();
            return !_isEmpty;
        };
        return stereotypes.stream().filter(_function).collect(Collectors.toList());
    }

    private String createContent(Map<String, String> attributes) {
        StringBuilder content = new StringBuilder();
        Iterator<String> iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            StringBuilder _append = content.append(key).append(":");
            String _escapeQuotes = this.escapeQuotes(attributes.get(key));
            String _plus = "\"" + _escapeQuotes;
            String _plus_1 = _plus + "\"";
            _append.append(_plus_1);
            boolean _hasNext = iter.hasNext();
            if (!_hasNext) continue;
            content.append(",");
        }
        return content.toString();
    }

    public String escapeQuotes(String value) {
        return StringEscapeUtils.escapeJava((String)value);
    }

    @Override
    public ModelId getModelId() {
        String _name = this.specification.getInfoModel().getId().getName();
        String _plus = _name + "PayloadMapping";
        String _namespace = this.specification.getInfoModel().getId().getNamespace();
        String _plus_1 = _namespace + ".mapping.";
        String _lowerCase = this.specification.getInfoModel().getId().getName().toLowerCase();
        String _plus_2 = _plus_1 + _lowerCase;
        String _version = this.specification.getInfoModel().getId().getVersion();
        return new ModelId(_plus, _plus_2, _version);
    }
}

